#!/bin/sh
PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:

#TTY="/dev/null"
TTY=$(tty)
ssutil_log=/var/log/ssave.sh.log
ECHO="echo"


######################################################################################
# NAME
#    cmd_chassis - VF mode chassis cmd
#
# SYNOPSIS
#    cmd_chassis cmd cmd-arg ..
#
# DESCRIPTION
#
# OPERANDS
#    cmd cmd-arg ..
#####################################################################################
cmd_chassis()
{
#    setcontext chassis
    $ECHO "********************************************************"
    clicmd=${1##*/}
    $ECHO -e "CHASSISCMD $@:"
    #$ECHO -e "$clicmd $2 $3 $4 $5 $6 $7 $8 $9:"
    date
    $ECHO "********************************************************"
    $ECHO -n . > $TTY
    newline=1
    #$ECHO  "$@:" > $TTY
    let cliidx++
    $ECHO "$cliidx $SS_MODULE CH $@" >> $ssutil_log
    $ECHO -e "$@:"	
    time $@

    rc=$?
    if [ $rc -ne 0 ]
    then
      $ECHO "CLI ERR:$rc $@" >> $ssutil_log
    fi
    $ECHO ""
    $ECHO -e "** SS CMD END **"
}

catfile()
{
	if [ -f $1 ]; then
		$CHASSISCMD /bin/cat $1
	else
		/bin/echo "File $1 not found"
	fi
}
CATFILE=catfile

catfile_rm()
{
	if [ -f $1 ]; then
		$CHASSISCMD /bin/cat $1
		/bin/rm $1
	else
		/bin/echo "File $1 not found"
	fi
}
CATFILE_RM=catfile_rm

group_show() {
    $ECHO "********************************************************"
    $ECHO $1
    $ECHO "********************************************************"
    $ECHO "********************************************************" >> $ssutil_log
    $ECHO $1 >> $ssutil_log
    $ECHO "********************************************************" >> $ssutil_log
    date  >> $ssutil_log
    cliidx=0
    time $1

    #$ECHO -e "\n" > $TTY
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "vmstat:"						      >> $ssutil_log
    vmstat							      >> $ssutil_log
    $ECHO "loadavg:"						      >> $ssutil_log
    /bin/cat /proc/loadavg					      >> $ssutil_log
    $ECHO "/tmp usage:"						      >> $ssutil_log
    du -h /tmp							      >> $ssutil_log
    $ECHO "============================================================================="  >> $ssutil_log
    $ECHO "$SS_MODULE Group End: $1"				      >> $ssutil_log
    date                                                              >> $ssutil_log
    $ECHO "********************************************************"  >> $ssutil_log

    $ECHO "$SS_MODULE Group End: $1"
    date
    $ECHO "********************************************************"

    newline=1
    if [ $newline -eq 1 ]
    then
        $ECHO  " " > $TTY
    fi

	RETVAL=`echo $?`
}
EXEC_GROUP=group_show


# *******************************************
# Collect pre supportsave data
# *******************************************
start_pre()
{
	start_main

    $CATFILE_RM /var/log/ss.log.old

    # ouput ssave.sh.log
    $CATFILE /var/log/ssave.sh.log

	# ouput supportsave.conf
    $CHASSISCMD /bin/cat /etc/fabos/supportsave.conf

    # ouput console log
    $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog
	
	/bin/echo "sslog.old file "
	if [ -f /var/log/sslog.old ]
	then
		$CHASSISCMD /bin/cat /var/log/sslog.old
	fi
	
	/bin/echo "/var/log/ss.log.old "
	if [ -f /var/log/ss.log.old ]; then
		$CHASSISCMD /bin/cat /var/log/ss.log.old
	fi
    # ouput 
    $CHASSISCMD  /fabos/cliexec/catconsole /proc/
    $CHASSISCMD  /fabos/cliexec/errdumpall

    # ISC related /proc entries
    $CHASSISCMD  /bin/cat /proc/isc/SWBD$sw_platform/sap
    $CHASSISCMD /bin/cat /proc/isc/SWBD$sw_platform/epd
    $CHASSISCMD /bin/cat /proc/isc/SWBD$sw_platform/dropped

    $CHASSISCMD /bin/cat /proc/hasm/ham

	# fwdl.log
	if [ -f /var/log/fwdl.log ]
	then
	$CHASSISCMD  /bin/cat /var/log/fwdl.log
	fi

	# fwdl.log.save
	if [ -f /var/log/fwdl.log.save ]
	then
	$CHASSISCMD  /bin/cat /var/log/fwdl.log.save
	fi

	# fwdl.log in secondary partition
	if [ -f /mnt/var/log/fwdl.log ]
	then
	$CHASSISCMD  /bin/cat /mnt/var/log/fwdl.log
	fi

	# fwdl.log.save in secondary partition
	if [ -f /mnt/var/log/fwdl.log.save ]
	then
	$CHASSISCMD  /bin/cat /mnt/var/log/fwdl.log.save
	fi

}

# *******************************************
# Collect post supportsave data
# *******************************************
start_post()
{  
    $CHASSISCMD /fabos/cliexec/catconsole /proc/consolelog

	$CATFILE_RM /var/log/assert.log

    # Print /var/log/messages in oldest to latest order.
    for file_no in [5 4 3 2 1]
    do 
		$CATFILE /var/log/messages.$file_no
    done
        
	$CATFILE  /var/log/messages

    $CHASSISCMD /fabos/cliexec/errdumpall
	
    $CATFILE /var/log/sslog
	
    # output ss.log
    $CATFILE_RM /var/log/ss.log

    # ouput ssave.sh.log
    $CATFILE_RM /var/log/ssave.sh.log

    # output supportsave error log /tmp/ss.log
    $CATFILE /var/log/ss_module_log
}

start_os()
{
  #tr did not like the spaces
  #export TERMINFO=/usr/share/terminfo
  $CHASSISCMD printenv
  $CHASSISCMD /usr/bin/w
  $CHASSISCMD /usr/bin/vmstat
  #$CHASSISCMD /usr/bin/top -n1
  $CHASSISCMD /usr/bin/iostat
#  $CHASSISCMD /sbin/mii-tool -vvv
  $CHASSISCMD /bin/df -h
  $CHASSISCMD /usr/bin/du -xh /
  /bin/echo "********************************************************"
  /bin/echo "        Top Ten Most Disk Consuming Files         "
  /bin/echo "********************************************************"
  /usr/bin/find / -fstype nfs -prune -o -path /mnt -prune -o -printf '%s %p\n'|sort -nr|head
  /bin/echo "********************************************************"

  # list /var/log dir
  $CHASSISCMD /bin/ls -l /var/log
  $CHASSISCMD /bin/ls -l /tmp

  # had a request for -aux?
  $CHASSISCMD /bin/ps exfcl

  $CHASSISCMD /bin/rpm -qa

  # Why not use the dmesg command, cause the log is overwritten by other kernel
  # modules. /var/log/dmesg preserve dmesg info during the boot up.
  $CATFILE /var/log/dmesg

  $CHASSISCMD /bin/dmesg

  $CATFILE /etc/fstab

  $CATFILE /etc/mtab

  $CATFILE /proc/sys/kernel/printk
  
  $CATFILE /proc/net/tcp6

  # linux proc
  proc_entries="buddyinfo,cmdline,cpuinfo,crypto,devices,diskstats,filesystems,interrupts,iomem,ioports,loadavg,locks,meminfo,misc,modules,mounts,mtd,net/tcp,net/udp,net/netstat,net/sockstat,panicdump,partitions,pci,pdmisc,sched_debug,slabinfo,softirqs,stat,tty/drivers,uptime,version,vmallocinfo,zoneinfo*/fpga,ddr_ecc/ecc_stats"

  for proc_entry in `/bin/echo $proc_entries | /usr/bin/tr "," "\n"`
  do
    $CATFILE /proc/$proc_entry
  done

  $CHASSISCMD /usr/bin/find /core_files /mnt/core_files -type f

   # icmp and tcp burstrate
#  $CATFILE /proc/sys/net/ipv4/conf/eth0/ip_unreachable
#  $CATFILE /proc/sys/net/ipv4/conf/eth0/icmp_echo_ignore
#  $CATFILE /proc/sys/net/ipv4/conf/eth0/icmp_rlimit_enable
#  $CATFILE /proc/sys/net/ipv4/icmp_ratemask
#  $CATFILE /proc/sys/net/ipv6/conf/eth0/ipv6_unreach
#  $CATFILE /proc/sys/net/ipv6/conf/eth0/echo_ignore
#  $CATFILE /proc/sys/net/ipv6/icmp/ratelimit
#  $CATFILE /proc/sys/net/ipv4/tcp_rate_limit
#  $CATFILE /proc/sys/net/ipv4/tcp_rate_limit_drop_time
#  $CATFILE /proc/net/tcp_rate_limit_log
#  $CATFILE /proc/net/netlink
#  $CATFILE /etc/icmp.conf
#  $CATFILE /etc/tcpburstrate.conf

  $CHASSISCMD /sbin/bootenv
  $CHASSISCMD /sbin/sin
  $CHASSISCMD /bin/df
  $CHASSISCMD /sbin/ifconfig
  $CHASSISCMD /sbin/route
  $CHASSISCMD /bin/hostname
#  $CHASSISCMD cat /proc/net/arp
  $CHASSISCMD /sbin/ip -s link
  $CHASSISCMD /sbin/ip -s addr
  $CHASSISCMD /bin/netstat -an
  $CHASSISCMD /bin/netstat -ng
#  $CATFILE /proc/vsd_info
#  $CATFILE /proc/standby_console
#  $CATFILE /proc/hv_console
#  for memfile in `/bin/ls -tr /var/log/mstatdir/memorystatus*`
#  do
#    $CATFILE $memfile
#  done

}

start_main()
{
	start_$sw_platform

}

start_36()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_47()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_50()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_55()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_68()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_78()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_81()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_84()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_85()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_88()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_89()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_sys()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

# ***** Main ****************************************
  CHASSISCMD="cmd_chassis"
  # set platform
  sw_platform=`/sbin/sin 2>/dev/null | /bin/grep SWBD | /usr/bin/cut -d ' ' -f 2 | /usr/bin/cut -c 5-6`
  group_show start_sys

 for param in $@
  do
    # remove debug switch, if present, processed at top
    if [ "$param" = "--pre" ]
    then
      group_show start_pre
	  group_show start_os
    fi

    if [ "$param" = "--post" ]
     then
     group_show start_post
    fi

    if [ "$param" = "--main" ]
     then
     group_show start_main
    fi

    $ECHO  " " > $TTY
    exit 0
  done

