# RESET for lab-4 using the mii port
# expects tcsh as shell to use
# Assumes linux eth1 is hooked to the mii port
 
# Set DT location and MII linux interface name
export DT="/fabos/libexec/dt.ppc --i eth3 --apdmawa on"

export SDK="/boot"

set tod = `date +"%s"`
set tod_hex=`printf "%#x\n" $tod`
echo writeoptions 0x00000012 ${tod_hex} | ${DT}
 
# Configure the Host 0 GMAC.
# Config register 6 = RX_PAUSE_EN | TX_PAUSE_EN | Pause time (0x1f000000)
echo write 0x80002018 0x00 0x1f 0x00 0x06 | ${DT}

# Config register 1 = PROMISC_MODE
echo write 0x80002004 0x00 0x00 0x00 0x01 | ${DT}

# Config register 0 = WATCHDOG_DIS | JABBER_DIS | FRMBURST_EN | JUMBOFRM_EN |

#                     BIGENDIAN_EN | RX_OWN_DIS | FULLDPLX_EN |
#                     DEFERRAL_CHK_EN | TRANS_EN | RECEV_EN
echo write 0x80002000 0x00 0xf0 0x68 0x1c | ${DT}

#

# Configure the Host 1 GMAC.
# Config register 6 = RX_PAUSE_EN | TX_PAUSE_EN | Pause time (0x1f000000)
echo write 0x80003018 0x00 0x1f 0x00 0x06 | ${DT}

# Config register 1 = PROMISC_MODE
echo write 0x80003004 0x00 0x00 0x00 0x01 | ${DT}

# Config register 0 = WATCHDOG_DIS | JABBER_DIS | FRMBURST_EN | JUMBOFRM_EN |
#                     BIGENDIAN_EN | RX_OWN_DIS | FULLDPLX_EN |
#                     DEFERRAL_CHK_EN | TRANS_EN | RECEV_EN
echo write 0x80003000 0x00 0xf0 0x68 0x1c | ${DT}

# Configure Network GMACs last avoids seeing network traffic until the
# eSC is configured.
 
# Configure the Network 0 GMAC.
# Config register 6 = RX_PAUSE_EN | TX_PAUSE_EN | Pause time (0x1f000000)
echo write 0x80000018 0x00 0x1f 0x00 0x06 | ${DT}

# Config register 1 = PROMISC_MODE

echo write 0x80000004 0x00 0x00 0x00 0x01 | ${DT}

# Config register 0 = WATCHDOG_DIS | JABBER_DIS | FRMBURST_EN | JUMBOFRM_EN |

#                     BIGENDIAN_EN | RX_OWN_DIS | FULLDPLX_EN |

#                     DEFERRAL_CHK_EN | TRANS_EN | RECEV_EN

echo write 0x80000000 0x00 0xf0 0x68 0x1c | ${DT}

#

# Configure the Network 1 GMAC.

# Config register 6 = RX_PAUSE_EN | TX_PAUSE_EN | Pause time (0x1f000000)

echo write 0x80001018 0x00 0x1f 0x00 0x06 | ${DT}

# Config register 1 = PROMISC_MODE

echo write 0x80001004 0x00 0x00 0x00 0x01 | ${DT}

# Config register 0 = WATCHDOG_DIS | JABBER_DIS | FRMBURST_EN | JUMBOFRM_EN |

#                     BIGENDIAN_EN | RX_OWN_DIS | FULLDPLX_EN |

#                     DEFERRAL_CHK_EN | TRANS_EN | RECEV_EN

echo write 0x80001000 0x00 0xf0 0x68 0x1c | ${DT}


# force the board into Fast Bypass mode - all traffic flows in clear between
# host and network ports

echo writeoptions 0x00000000 0x0000 0x0 0x0 0x0 0x00 0x1 0x1 0x1 0x1 0x0 0x0 0x0 0x0 | ${DT}


