#!/bin/sh

LOCKFILE=/tmp/fcdump.lock
CVLCDBG=/fabos/bin/cvlc_dbg
CVLCFCTAR=/tftpboot/fcdump.txt.tar


/bin/rm -f ${CVLCFCTAR} >/dev/null 2>&1
/bin/rm -f ${LOCKFILE} >/dev/null 2>&1
${CVLCDBG} -fcdump

if [ -e /proc/tape ]
then 
	for TAPE in `find /proc/tape/ -type f -print`
	do
		echo ""
		echo "CMD: " $TAPE
		cat $TAPE
	done
else
	echo "Tape status is not available."
fi

i=0
while [ ! -f ${LOCKFILE} ]
do
    i=`expr $i + 1`
    if [ $i -gt 30 ]
    then 
        date
        echo "FC Dump Timedout. Could not generate FC dump in 60 seconds"
		break
    fi
    sleep 2
done
/bin/rm -f ${LOCKFILE} >/dev/null 2>&1

