#!/bin/sh
PATH=/bin:/usr/bin:/usr/sbin:/fabos/bin:/fabos/link_bin:

#TTY="/dev/null"
TTY=$(tty)
log=/var/log/ssave.sh.log
ECHO="echo"

cmd_chassis()
{

$ECHO "********************************************************"
title=${1##*/}
$ECHO -e "$title $2 $3 $4 $5 $6 $7 $8 $9:"
$ECHO "********************************************************"
time $@
$ECHO ""
}

group_show() {
    $ECHO "********************************************************"
    $ECHO $1
    $ECHO "********************************************************"
    $ECHO "********************************************************" >> $log
    $ECHO $1 >> $log
    $ECHO "********************************************************" >> $log
    date  >> $log
    cliidx=0
    time $1
    date  >> $log
    $ECHO "**** End $1 group ****" >> $log
}


# *******************************************
# Collect pre supportsave data
# *******************************************
start_pre()
{
    # ouput supportsave.conf
    $CHASSISCMD /bin/cat /etc/fabos/supportsave.conf

	/bin/echo "sslog.old file "
	if [ -f /var/log/sslog.old ]
	then
		$CHASSISCMD /bin/cat /var/log/sslog.old
	fi
	
	/bin/echo "/var/log/ss.log.old "
	if [ -f /var/log/ss.log.old ]
	then
		$CHASSISCMD /bin/cat /var/log/ss.log.old
	fi
    # ouput console log
    $CHASSISCMD  /fabos/cliexec/catconsole /proc/consolelog

    $CHASSISCMD  /fabos/cliexec/errdumpall

    # ouput ssave.sh.log
    if [ -f /var/log/ssave.sh.log ]	
    then	
	$CHASSISCMD  /bin/cat /var/log/ssave.sh.log
    fi

    if [ -f /var/log/ssave.sh.log ]
    then	
	/bin/rm -f /var/log/ssave.sh.log
    fi

    # ISC related /proc entries
    $CHASSISCMD  /bin/cat /proc/isc/SWBD$sw_platform/sap

    $CHASSISCMD /bin/cat /proc/isc/SWBD$sw_platform/epd

    $CHASSISCMD /bin/cat /proc/isc/SWBD$sw_platform/dropped

    $CHASSISCMD /bin/cat /proc/hasm/ham

	# fwdl.log
	if [ -f /var/log/fwdl.log ]
	then
	$CHASSISCMD  /bin/cat /var/log/fwdl.log
	fi

	# fwdl.log.save
	if [ -f /var/log/fwdl.log.save ]
	then
	$CHASSISCMD  /bin/cat /var/log/fwdl.log.save
	fi

	# fwdl.log in secondary partition
	if [ -f /mnt/var/log/fwdl.log ]
	then
	$CHASSISCMD  /bin/cat /mnt/var/log/fwdl.log
	fi

	# fwdl.log.save in secondary partition
	if [ -f /mnt/var/log/fwdl.log.save ]
	then
	$CHASSISCMD  /bin/cat /mnt/var/log/fwdl.log.save
	fi

}

# *******************************************
# Collect post supportsave data
# *******************************************
start_post()
{  
    if [ -f /var/log/ssave.sh.log ]	
    then
	 $CHASSISCMD /bin/cat /var/log/ssave.sh.log
    fi

    if [ -f /var/log/sslog ]	
    then
	 $CHASSISCMD /bin/cat /var/log/sslog
    fi

    $CHASSISCMD /fabos/cliexec/catconsole /proc/consolelog

    if [ -f /var/log/assert.log ]
    then
        $CHASSISCMD /bin/cat /var/log/assert.log
		/bin/rm /var/log/assert.log
    fi

    # Print /var/log/messages in oldest to latest order.
    for file_no in [5 4 3 2 1]
    do 
        if [ -f /var/log/messages.$file_no ]
        then
            $CHASSISCMD  /bin/cat /var/log/messages.$file_no
        fi
    done
        
    if [ -f /var/log/messages ]
    then
        $CHASSISCMD  /bin/cat /var/log/messages
    fi

    $CHASSISCMD /fabos/cliexec/errdumpall
	
	if [ -f /var/log/ss.log ]
	then
		$CHASSISCMD  /bin/cat /var/log/ss.log
	fi
}

start_main()
{
	start_$sw_platform

}

start_36()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_47()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_50()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_55()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_68()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_78()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_81()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_84()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_85()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_88()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_89()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

start_sys()
{
     $ECHO "Platform: $sw_platform"
     $ECHO "Date:"
     date
}

# ***** Main ****************************************
  CHASSISCMD="cmd_chassis"
  # set platform
  sw_platform=`/sbin/sin 2>/dev/null | /bin/grep SWBD | /usr/bin/cut -d ' ' -f 2 | /usr/bin/cut -c 5-6`
  group_show start_sys

 for param in $@
  do
    # remove debug switch, if present, processed at top
    if [ "$param" = "--pre" ]
    then
      group_show start_pre
    fi

    if [ "$param" = "--post" ]
     then
     group_show start_post
    fi

    if [ "$param" = "--main" ]
     then
     group_show start_main
    fi

    $ECHO  " " > $TTY
    exit 0
  done

