#!/bin/sh
#
#  Panic Dump, UP Load Post-Fabos parameters.
#  some of the paramters can be obtained only ater the fabos is up and
#  running, such as WWN.
#  This script is used to obtain such information and upload them to
#  PD_MISC client of panicdump, so we get them when the system panics
#  in future.
#
WORK_FILE=/tmp/tmp_ksyms_file
MISC_FILE=/core_files/.misc_file # if you change this, also change
                                # corresponding entry in pdul_misc_pre.sh and
                                # pdul_misc_post.sh and pdcheck.sh
#
# we will take a copy of /proc/ksyms, so the panic analyzers can take a
# look at it if they ever want to
#
cat /proc/kallsyms >  $WORK_FILE # save this in the /tmp, which is RAM
old_checksum="`/usr/bin/cksum ${WORK_FILE}|/usr/bin/cut -f1,2 -d' '`"
new_checksum="`/usr/bin/cksum ${MISC_FILE} 2>/dev/null |/usr/bin/cut -f1,2 -d' '`"
if [ "$old_checksum" != "$new_checksum" ]
then
	/bin/cp ${WORK_FILE} ${MISC_FILE}
	/bin/sync
	/bin/sync
	/bin/sync # three times!? why???
                  #
                  #   "In case you're wondering: the reason for three
                  #   syncs is that in the early days of UNIX, when the
                  #   commands were typed separately, that usually gave
                  #   sufficient time for most disk I/O to be finished."
                  #
                  #   - Lars Wirzenius
                  #     from the Linux System Adminstrator's Guide
fi

sleep 60  # we wait so that we get all the info below

if [ -f /fabos/sbin/hashow ]
then
	# Let us store the HAM information
	printf "Section=HA Show Output\n" > /proc/pdmisc
	/fabos/sbin/hashow | /bin/sed -e 's/^/haShow=/' | while :
	do
		read oneLine
		[ -z "$oneLine" ] && break
		printf "$oneLine\n" > /proc/consolelog
	done
fi


printf "Section=sin Output\n" > /proc/pdmisc
/sbin/sin | /bin/sed -e 's/^/sin=/' | while :
do
	read oneLine
	[ -z "$oneLine" ] && break
	printf "$oneLine\n" > /proc/consolelog
done
