/*
 *  Copyright (c) 2007 Brocade Communication Systems, Inc.
 *  All rights reserved.
 *
 */

#ifndef _SAP_OP_H
#define _SAP_OP_H

/* SAP code definitions */


typedef enum _SAP {
	SAP_SB_MGMT				= 1,
	SAP_BLADE_MGMT			= 2,
	SAP_PORT_MGMT			= 3,

	SAP_MARATHON_MPC_MGMT	= 10,
	SAP_MARATHON_FCIP_MGMT	= 11,
	SAP_MARATHON_BLADE_MGMT	= 12,
	SAP_MARATHON_HIFN_MGMT	= 13,
	SAP_MARATHON_TEST_MGMT	= 14,

	SAP_ICPD_MGMT			= 15,
	SAP_IBPD_MGMT			= 16,
	SAP_ISCSI_PORT_TCP		= 17,
	SAP_ISCSI_PORT_ISCSI	= 18,
	SAP_ISCSI_PORT_MGMT		= 19,
	SAP_ISCSI_BP_MGMT		= 20,
	SAP_IPSD_MGMT			= 21,
	SAP_PC_MGMT				= 22,
	SAP_ASIC_MGMT			= 23,

	SAP_IRONMAN_BLDRV_MGMT	= 24,
	SAP_IRONMAN_IP_MGMT		= 25,
	SAP_IRONMAN_BLADE_MGMT	= 26,
	SAP_IRONMAN_CHIP_MGMT	= 27,
	SAP_IRONMAN_TEST_MGMT	= 28,
	SAP_IRONMAN_BLPTIO_MGMT	= 29,

	SAP_SCP_SBP_MGMT		= 30,
	SAP_LICENSE_MGMT		= 31,
	SAP_CAL_MGMT			= 32,
	SAP_ARR_MGMT			= 33,
	SAP_NS_MGMT				= 34,
	SAP_EVM_MGMT			= 35,
	SAP_CVLM_MGMT			= 36,
	SAP_CVLC_MGMT			= 37,
	SAP_REKEY_MGMT			= 38,
	SAP_CTAPE_MGMT			= 39,

	SAP_LANCE_BLDRV_MGMT	= 40,

	SAP_LANCE_IP_MGMT       = 41,
	SAP_LANCE_BLADE_MGMT    = 42,
	SAP_LANCE_CHIP_MGMT     = 43,
	SAP_LANCE_TEST_MGMT     = 44,
	SAP_LANCE_BLPTIO_MGMT	= 45,
	SAP_LANCE_SP_MGMT		= 46,
	SAP_LANCE_DEK_MGMT		= 47,
	SAP_LANCE_KEK_MGMT		= 48,
	SAP_LANCE_KEY_VAULT		= 49,
	SAP_LANCE_EE_MGMT		= 50,
	SAP_CNM_MGMT            = 51,
	SAP_LANCE_SP_INIT_MGMT	= 52,
	SAP_LANCE_BC_MGMT		= 53,
	SAP_LANCE_OP_EVT_MGMT	= 54,
	SAP_CP_BP_DIAG_COMM 	= 55,	
	SAP_SAS_MGMT			= 56,

	SAP_DCE_BLDRV_MGMT,		/* 57 */
#ifdef SECURE_ERASE_ENABLE
	SAP_SECURE_ERASE_MGMT	= 58,
	//Define next SAP entry as 59, otherwise when this code is enabled
	//We will have problems.
#endif
	/*
	 * Add new SAP entry above this line.
	 */
	SAP_OF_LAST
} SAP;


/*
 * SAP opcode for Scimitar.  Just alias that of Marathon
 */
#define	SAP_SCIMITAR_MPC_MGMT	 SAP_MARATHON_MPC_MGMT
#define	SAP_SCIMITAR_CPSAS_MGMT  SAP_MARATHON_FCIP_MGMT

/*
 * SAP opcode for Striker.  Just alias that of Marathon
 */

#define	SAP_STRIKER_MPC_MGMT	 SAP_MARATHON_MPC_MGMT
#define	SAP_STRIKER_CPCDC_MGMT   SAP_MARATHON_FCIP_MGMT



/*
**  DEFINE OPCODES FOR VARIOUS SAPs
**	OPCODE from 1 to 30 are reseved for common group operations
**  Group specific op code starts from 41
*/

/*
 *  SAP_CP_BP_DIAG_COMM(55) OPCODES 
 */
typedef enum _CP_BP_DIAG_COMM {
	DIAG_START				= 41,
	DIAG_START_RESP,				/* 42 */
	DIAG_DO_TEST,					/* 43 */
	DIAG_DO_TEST_RESP,				/* 44 */
	DIAG_DONE,						/* 45 */
	DIAG_DONE_RESP,					/* 46 */

	/*
	 * Add new OP entry above this line.
	 */
	DIAG_OP_LAST
} CP_BP_DIAG_COMM;

/*
 * SAP_SB_MGMT(1) OPCODES
 */
typedef enum _SB_MGMT_OP {
	SB_SUBSCRIBE_REQ		= 41,
	SB_SUBSCRIBE_RSP,				  /* 42 */
	SB_DEL_SUBSCRIBE_REQ,			  /* 43 */
	SB_DEL_SUBSCRIBE_RSP,			  /* 44 */
	SB_GET_SAP_OP_SUBSCRIBERS_REQ,    /* 45 */
	SB_GET_SAP_OP_SUBSCRIBERS_RSP,    /* 46 */
	SB_CP_FAILOVER,					  /* 47 */
	SB_OF_LAST
} SB_MGMT_OP;


/*
 * SAP_BLADE_MGMT(2) OPCODES
 */
typedef enum _BLADE_MGMT_OP {
	BMGMT_HELLO_REQ		= 41,
	BMGMT_HELLO_RESP,		/* 42 */
	BMGMT_VERSION_REQ,		/* 43 */
	BMGMT_VERSION_RESP,		/* 44 */
	BMGMT_FWINSTALL_REQ,	/* 45 */
	BMGMT_FWINSTALL_RESP,	/* 46 */
	BMGMT_FWCOMMIT_REQ,		/* 47 */
	BMGMT_FWCOMMIT_RESP,	/* 48 */
	BMGMT_REBOOT_REQ,		/* 49 */
	BMGMT_FWABORT_REQ,		/* 50 */
	BMGMT_FWABORT_RESP,		/* 51 */
	BMGMT_CP_FAILOVER,		/* 52 */

	/*
	 * Applications on AP must wait for this OP before they can
	 * communicate with their CP counterparts. This op indicates that
	 * the version check with the CP has passed, and the AP version is
	 * compatible with that of CP.
	 */
	BMGMT_APPS_START,		/* 53 */
	BMGMT_SFP_INFO,			/* 54 */
	BMGMT_TIMEUPDATE,		/* 55 */ /* time update from CP to BP */
	BMGMT_BLADE_ON,			/* 56 */ /* Blade is now up and running	*/
	BMGMT_SET_DEBUG_FLAG,	/* 57 */ /* Set debug flag				*/
	BMGMT_VERSION_INFO,		/* 58 */ /* Latest BP version info from BC	*/
	BMGMT_BLADE_FAULTY,		/* 59 */ /* Blade is faulty, msg from BC	*/
	BMGMT_BLADE_HTBT_REQ,	/* 60 */ /* htbt request from BM to BC		*/
	BMGMT_BLADE_HTBT_RESP,	/* 61 */ /* htbt response from BC to BM		*/
	BMGMT_BLADE_DATA_REQ,	/* 62 */ /* blade specific data req from BC */
	BMGMT_BLADE_DATA_RESP,	/* 63 */ /* blade specific data resp from BM */

	/*
	 * MACE/LANCE Port group related opcode
	 */
	BMGMT_PRT_GRP,
	BGMGT_FPGA_DOWNLOAD_OK,
	BGMGT_FPGA_DOWNLOAD_FAIL,
	/*
	 * Add new OP entry above this line.
	 */
	BMGMT_OP_LAST
} BLADE_MGMT_OP;


/*
 * SAP_PORT_MGMT(3) OPCODES
 */
typedef enum _PORT_MGMT_OP {
	PMGMT_PORT_START	= 41,
	PMGMT_PORT_STOP,			/* 42  */
	PMGMT_PORT_ENABLE,			/* 43  */
	PMGMT_PORT_DISABLE,			/* 44  */
	PMGMT_PORT_DIAG_ENABLE,		/* 45  */
	PMGMT_PORT_DIAG_DISABLE,	/* 46  */

	/*
	 * Add new OP entry above this line.
	 */
	PMGMT_OP_LAST
} OBJMGR_OP;

/*
 * SAP_MARATHON_MPC_MGMT(10) OPCODES
 */
typedef enum _MPC_MGMT_OP {
	MPC_CHIPSTART_RSP	= 41,
	MPC_CHIPSTART_CB,
	MPC_CHIPSTARTED,
	MPC_CHIPSTOP_RSP,
	MPC_CHIPFAILED,
	MPC_CHIPFNUP,
	MPC_CHIPATTACH_DONE,
	MPC_CHIP_WSTART_RSP,
	MPC_IPSEC_STATUS,
	MPC_FIPS_IPSEC,
	MPC_FIPS_IPSEC_FAILURE,

	/* Internal to MPC, MBD, 1250/4350 drivers */
	MPC_GET_CHFNSTATUS = 80,
	MPC_CHIP_START,
	MPC_CHIP_STOP,
	MPC_PORT_ENABLE,
	MPC_PORT_DISABLE,
	MPC_IPSEC_CONFIG,
	MPC_IPSEC_ENABLE,
	MPC_IPSEC_DISABLE,
	MPC_LINK_DOWN,			/* per rcvd IPPM_LINK_DOWN from 1250 */
	MPC_CHIP_WSTART,
	MPC_CHIP_WSTARTED,
	MPC_UP,	
	MPC_PORT_WWN,
	/*
	 * Add new OP entry above this line
	 */
	MPC_OP_LAST
} MPC_OP;

/*
 * SAP_MARATHON_FCIP_MGMT(11) OPCODES
 */
typedef enum _MFCIP_MGMT_OP {
	MFCIP_CHIP_START	= 41,
	MFCIP_CHIP_STOP,
	MFCIP_PORT_ENABLE,
	MFCIP_PORT_DISABLE,
	MFCIP_CHIP_WSTART,			/* BP WARM start; don't reload 4350/1250 fw */
	MFCIP_IPSEC_CFG,
	MFCIP_IPSEC_ENABLE,
	MFCIP_IPSEC_DISABLE,
	MFCIP_LINK_DOWN,			/* per rcvd IPPM_LINK_DOWN from 1250 */
	MFCIP_FPGA_DOWNLD_REQ,
	/*
	 * Add new OP entry above this line
	 */
	MFCIP_OP_LAST
} MFCIP_OP;

/*
 * SAP_SCIMITAR_CP{SAS|CDC}_MGMT(11) OPCODES
 * They are just alias of the FCIP ones
 */
#define MCPSAS_CHIP_START		MFCIP_CHIP_START
#define MCPSAS_CHIP_STOP		MFCIP_CHIP_STOP
#define MCPSAS_PORT_ENABLE		MFCIP_PORT_ENABLE
#define MCPSAS_PORT_DISABLE		MFCIP_PORT_DISABLE
#define MCPCDC_CHIP_START		MFCIP_CHIP_START
#define MCPCDC_CHIP_STOP		MFCIP_CHIP_STOP
#define MCPCDC_PORT_ENABLE		MFCIP_PORT_ENABLE
#define MCPCDC_PORT_DISABLE		MFCIP_PORT_DISABLE

/*
 * SAP_MARATHON_BLADE_MGMT(12) OPCODES
 */
typedef enum _MBLADE_MGMT_OP {
	MBD_CPFAILOVER	= 41,
	MBD_RESUME,			/* 42 */
	MBD_CONFIGDONE,		/* 43 */
	MBD_BDON,			/* 44 - Blade driver ON		*/

	/*
	 * MBD internal OPs
	 */
	MBD_ATTACH = 80,
	MBD_GETBPCONFIG,
	/*
	 * Add new OP entry above this line
	 */
	MBD_OP_LAST
} MBD_OP;

/*
 * SAP_MARATHON_HIFN_MGMT(13) OPCODES
 */
typedef enum _HIFN_MGMT_OP {
	HIFN_CHIPSTART_RSP	= 41,
	HIFN_CHIPSTART_CB,
	HIFN_CHIPSTOP_RSP,
	HIFN_CHIPFAILED,
	HIFN_CHIPFNUP,
	HIFN_PORTFAILED,
	HIFN_IPSEC_STATUS,
	HIFN_CHIP_WSTART_RSP,
	HIFN_FIPS_IPSEC,
	HIFN_FIPS_IPSEC_FAILURE,
	/*
	 * Add new OP entry above this line
	 */
} HIFN_OP;

/*
 * SAP_MARATHON_TEST_MGMT(14) OPCODES
 */
typedef enum _TEST_MGMT_OP {
	MTST_PRINT_MSGCNT	= 41,
	MTST_TRACE			= 42,

	/*
	 * Add new OP entry above this line
	 */
	M_OP_LAST
} TEST_OP;

/*
 * SAP_ICPD_MGMT(15) OPCODES
 */
typedef enum _ICPD_MGMT_OP {
	ICPD_BLD_HELLO_REQ			= 41, /* icpd <- ibpd */
	ICPD_BLD_HELLO_RSP,			/* 42 icpd -> ibpd */
	ICPD_BLD_VERSION_REQ,		/* 43 icpd <- ibpd */
	ICPD_BLD_VERSION_RSP,		/* 44 icpd -> ibpd */
	ICPD_BLD_DIST_START_REQ,	/* 45 icpd -> ibpd */
	ICPD_BLD_DIST_START_RSP,	/* 46 icpd <- ibpd */
	ICPD_BLD_DIST_COMP_REQ,		/* 47 icpd <- ibpd */
	ICPD_BLD_DIST_COMP_RSP,		/* 48 icpd -> ibpd */
	ICPD_BLD_SESSION_GET_REQ,	/* 49 icpd -> ibpd */
	ICPD_BLD_SESSION_GET_RSP,	/* 50 icpd <- ibpd */
	ICPD_BLD_SESSION_DEL_REQ,	/* 51 icpd -> ibpd */
	ICPD_BLD_SESSION_DEL_RSP,	/* 52 icpd <- ibpd */
	ICPD_BLD_SESSION_CLR_REQ,	/* 53 icpd -> ibpd */
	ICPD_BLD_SESSION_CLR_RSP,	/* 54 icpd <- ibpd */
	ICPD_BLD_GET_ACK,			/* 55 icpd -> ibpd */
	ICPD_BLD_PORT_GET_REQ,		/* 56 icpd -> ibpd */
	ICPD_BLD_PORT_GET_RSP,		/* 57 icpd <- ibpd */
	ICPD_BLD_PORT_CLR_REQ,		/* 58 icpd -> ibpd */
	ICPD_BLD_PORT_CLR_RSP,		/* 59 icpd <- ibpd */
	ICPD_BLD_IQN_GET_REQ,		/* 60 icpd -> ibpd */
	ICPD_BLD_IQN_GET_RSP,		/* 61 icpd <- ibpd */
	ICPD_BLD_PORT_SET_REQ,		/* 62 icpd -> ibpd */
	ICPD_BLD_PORT_SET_RSP,		/* 63 icpd <- ibpd */
	ICPD_MMI_CREATE_REQ,		/* 64 */
	ICPD_MMI_DELETE_REQ,		/* 65 */
	ICPD_MMI_SET_REQ,			/* 66 */
	ICPD_MMI_GET_REQ,			/* 67 */
	ICPD_MMI_GET_NEXT_REQ,		/* 68 */
	ICPD_MMI_MGET_REQ,			/* 69 */
	ICPD_MMI_MSET_REQ,			/* 70 */
	ICPD_MMI_CREATE_RSP,		/* 71 */
	ICPD_MMI_DELETE_RSP,		/* 72 */
	ICPD_MMI_SET_RSP,			/* 73 */
	ICPD_MMI_GET_RSP,			/* 74 */
	ICPD_MMI_GET_NEXT_RSP,		/* 75 */
	ICPD_MMI_MGET_RSP,			/* 76 */
	ICPD_MMI_MSET_RSP,			/* 77 */
	ICPD_BLD_TGT_UPDATE,		/* 78 */
	ICPD_BLD_ITR_CLR,			/* 79 */
	ICPD_MGMT_OP_LAST
} ICPD_OP;

/*
 * SAP_IBPD_MGMT(16) OPCODES
 */
typedef enum _IBPD_MGMT_OP {
	IBPD_CFG_DIST_COMP			= 41, /* child of ibpd ->ibpd */
	IBPD_DBG_CMD,
	IBPD_LOGIN_EVENT_UPDATE,	/* ibpd -> icpd */
	IBPD_EVENT_GET_REQ,			/* icpd -> ibpd */
	IBPD_EVENT_GET_RSP,			/* icpd <- ibpd */
	IBPD_STATUS_UPDATE,			/* icpd -> ibpd */
	IBPD_ITR_CACHE_FULL_EVENT,	/* ibpd -> icpd */
	IBPD_PORTAL_GET_REQ,		/* icpd -> ibpd */
	IBPD_PORTAL_GET_RSP,		/* icpd <- ibpd */
	IBPD_PORTAL_UPDATE,			/* icpd <- ibpd */
	IBPD_EVENT_LOG_CLEAR,		/* icpd -> ibpd */
	IBPD_ICR_SET_REQ,			/* icpd -> ibpd */
	IBPD_ICR_SET_RSP,			/* ibpd -> icpd */
	IBPD_MGMT_OP_LAST
} IBPD_OP;

/*
 * SAP_ISCSI_PORT_TCP (17) OPCODES
 */

typedef enum{
	TCP_OPEN_REQ = 1,
	TCP_INIT_REQ = TCP_OPEN_REQ,
	TCP_OPEN_RSP,       /* 2 */
	TCP_CLOSE_REQ,      /* 3 */
	TCP_CLOSE_RSP,      /* 4 */
	TCP_EVENT,          /* 5 */
	TCP_QOS_REQ,        /* 6 */
	TCP_QOS_RSP,        /* 7 */
	TCP_QOS_DEL,        /* 8 */
	TCP_QOS_DEL_RSP,    /* 9 */

	TCP_INIT_RSP,        /* 10 ibpd --> Port ack for cnn open */
	TCP_DATA,            /* 11 ibpd <--> port */
	TCP_OPEN_RSP_ACK,    /* 12 ibpd --> Port ack for cnn open */
	TCP_UPDATE_CFG_REQ,  /* 13 ibpd <-->port after session reaches FFP*/
	TCP_UPDATE_CFG_RSP,  /* 14 Port --> ibpd */
	TCP_IP_UP_EVENT, 	/* 15 BP --> port ip ready event */
}OP_ISCSI_PORT_TCP;

/*
 * SAP_ISCSI_PORT_ISCSI (18) OPCODES
 */
typedef enum{
	ISCSI_NORMAL_LOGIN_REQ = 1,  /* 1 ibpd requests iSCSI Port to open target
								(ibpd->Port) */
	ISCSI_NORMAL_LOGIN_REQ_ACK,  /* 2 Port to BP - acks the req.this will trigger
									  the MNG_REQ to port from BP */
	ISCSI_NORMAL_LOGIN_RSP,      /* 3 iSCSI Port rsp to open target
									req (Port->ibpd) */
	ISCSI_LOGIN_ABORT_REQ,       /* 4 Abort any outstanding logins to the target */
	ISCSI_LOGIN_ABORT_RSP,       /* 5 Abort rsp (port to bp)*/
	ISCSI_SESSION_CLEANUP_REQ,   /* 6 Cleanup active session */
	ISCSI_SESSION_CLEANUP_RSP,   /* 7 Cleanup rsp (port to bp)*/
	/* New types for MC/S */
	ISCSI_CONN_REQ,              /* 8 ibpd-> all associated Port */
	ISCSI_CONN_RSP,              /* 9 Port-> ibpd(port to bp)*/
	ISCSI_CONN_CLEANUP_REQ,      /* 10 Cleanup active connection */
	ISCSI_CONN_CLEANUP_RSP,      /* 11 Cleanup active connection (port to bp)*/
	ISCSI_EVENT_REQ,             /* 12 event from port iscsi agent (port to bp)*/
	ISCSI_EVENT_RSP,             /* 13 event rsp from bp to port */
	ISCSI_STATIC_CLEAR_REQ,      /* 14 ibpd->port to clear the statistics */
	ISCSI_STATIC_CLEAR_RSP,      /* 15 clear the statistics rsp (port to bp)*/
	ISCSI_ADD_FC_TGT_REQ,        /* obsolete */
	ISCSI_FC_TGT_MNG_REQ,        /* 16 manage FC target at the port (bp to port) */
	ISCSI_FC_TGT_MNG_RSP,        /* 17 manage FC target rsp (port to bp) */
	ISCSI_CONN_STATS_REQ,		/* 18 get stats by session request */
	ISCSI_CONN_STATS_RES,		/* 19 get stats by session response */
	ISCSI_GBL_STATS_REQ,		/* 20 get global stats request */
	ISCSI_GBL_STATS_RES,		/* 21 get global stats response */
	ISCSI_CONN_STATS_CLEAR_REQ,	/* 22 clear stats by session request */
	ISCSI_CONN_STATS_CLEAR_RES,	/* 23 clear stats by session response */
	ISCSI_CLEAR_GBL_STATS_REQ,	/* 24 clear global stats request */
	ISCSI_CLEAR_GBL_STATS_RES	/* 25 clear global stats response */

}OP_ISCSI_PORT_ISCSI;



/*
 * SAP_IRONMAN_BLADE_MGMT OPCODES
 */
typedef enum _IBLADE_MGMT_OP {
	IBD_CPFAILOVER  = 41,
	IBD_RESUME,         /* 42 */
	IBD_CONFIGDONE,     /* 43 */
	IBD_GETBPCONFIG,

	/*
	 * Add new OP entry above this line
	 */
	IBD_OP_LAST
} IBD_OP;

/*
 * SAP_IRONMAN_CHIP_MGMT OPCODES
 */
typedef enum _IPC_MGMT_OP {
	IPC_CHIPSTART_RSP   = 41,
	IPC_CHIPSTART_CB,
	IPC_CHIPSTARTED,
	IPC_CHIPSTOP_RSP,
	IPC_CHIPFAILED,
	IPC_CHIPFNUP,


	/* Internal to IPC, IBD, 1125 drivers */
	IPC_GET_CHFNSTATUS = 80,
	IPC_CHIP_START,
	IPC_CHIP_STOP,
	/*
	 * Add new OP entry above this line
	 */
	IPC_OP_LAST
} IPC_OP;

/*
 * SAP_IRONMAN_TEST_MGMT OPCODES
 */
typedef enum _ITEST_MGMT_OP {
	ITST_PRINT_MSGCNT   = 41,
	ITST_TRACE,
	ITST_SEND_IPSDMSG,
	ITST_SEND_BLDMSG,
	ITST_SEND_PCMSG,
	ITST_RSP_PCMSG,
	ITST_CQFULL,
	ITST_HTBTDOWN,


	/*
	 * Add new OP entry above this line
	 */
	ITST_OP_LAST
} ITEST_OP;

/*
 * SAP_ISCSI_PORT_MGMT (19)
 */
typedef enum {
	PT_GE_EVENT = 41,
	PT_BI_EVENT,
	PT_CH_EVENT,
	PT_ISCSI_HTBT,
	PT_ISCSI_CQ,
	PT_ISCSI_CFG_DONE,
	PT_EVENT,
	/*
	 * Add new OP entry above this line
	 */
	PORT_OP_LAST
} PORT_OP;

/*
 * SAP_ISCSI_BP_MGMT (20)
 */
typedef enum {
	PTIO_CMD = 41,
	BP_ISCSI_HTBT,
	/*
	 * Add new OP entry above this line
	 */
	BP_OP_LAST
} BP_OP;

/*
 * SAP_PC_MGMT (22)
 */

/*
 * SAP_ASIC_MGMT (23)
 */
typedef enum{
	ASIC_CHIP_START	= 41,
	ASIC_CHIP_STOP,

	/*
	 * Add new OP entry above this line
	 */
	ASIC_OP_LAST
} ASIC_OP;

/*
 * SAP_IRONMAN_BLDRV_MGMT OPCODES
 */
typedef enum {
	IBDRV_MGMT_REQ = 41,
	IBDRV_MGMT_RSP,

	OP_IBDRV_LAST
} OP_IBDRV;

/*
 * SAP_IRONMAN_IP_MGMT OPCODES
 */
typedef enum {
	IIP_MGMT_REQ = 41,
	IIP_MGMT_RSP,
	OP_IIP_LAST
} OP_IIP;

typedef enum {
	PT_GET_TRACE_STAT = 41,
	PT_GET_TRACE_BUF,
	PT_TRACE_FLUSH,
	PT_SET_TRACE_CFG,
	OP_IRONMAN_BLPTIO_LAST
} OP_BLPTIO;


/*
 * SAP_SCP_MGMT(30) OPCODES
 */
typedef enum _SCP_SBP_MGMT_OP {
	SCP_BLD_HELLO_REQ			= 41, /* scpd <- sbpd */
	SCP_BLD_HELLO_RSP,			/* 42 scpd -> sbpd */

	SCP_MGMT_OP_LAST
} SCP_OP;

/*
 * SAP_LICENSE_MGMT(31) OPCODES
 */
typedef enum _SBP_LICENSE_OP {
	SCP_LICENSE_HELLO_REQ		= 41, /* scpd <- sbpd */
	SCP_LICENSE_HELLO_RSP,			/* 42 scpd -> sbpd */
	SCP_LICENSE_ADD_REQ,			/* 45 scpd <- sbplib */
	SCP_LICENCE_ADD_RSP,			/* 46 scpd -> sbplib */
	SCP_LICENCE_DELETE_REQ,		/* 47 scpd <- sbplib */
	SCP_LICENCE_DELETE_RSP,		/* 48 scpd -> sbplib */
	SCP_LICENCE_MODIFY_REQ,		/* 49 scpd <- sbplib */
	SCP_LICENCE_MODIFY_RSP,		/* 50 scpd -> sbplib */

	SBP_LICENSE_OP_LAST
} SBP_LICENSE_OP;

/*
 * SAP_CAL_MGMT (32) OP codes
 */
typedef enum _SBP_CAL_MGMT_OP {
	SCP_CAL_HELLO_REQ			= 41, 	/* cald <-- sbp */
	SCP_CAL_HELLO_RSP,					/* cald --> sbp */
	SCP_CAL_TEST_REQ,					/* cald <-- sbp */
	SCP_CAL_TEST_RSP,					/* cald --> sbp */
	SA_MGMT_REGISTER_MESSAGE,			/* BP --> CP 	*/
	SA_MGMT_REGISTER_RESP,				/* CP --> BP	*/
	SA_MGMT_APP_STATUS_REQ,				/* CP --> BP 	*/
	SA_MGMT_APPSTATUS_RESP,				/* BP --> CP	*/
	SA_MGMT_MOF_REQ,					/* CP --> BP	*/
	SA_MGMT_WBEM_REQUEST,				/* CP --> BP	*/

	SCP_CAL_OP_LAST
} SBP_CAL_MGMT_OP;

/*
 * SAP_ARR_MGMT (33) OP Codes
 */
typedef enum _SBP_ARR_MGMT_OP {
	SCP_ARR_HELLO_REQ			= 41,	/* arrd <-- sbp */
	SCP_ARR_HELLO_RSP,					/* arrd --> sbp */
	SCP_ARR_TEST_REQ,					/* arrd <-- sbp */
	SCP_ARR_TEST_RSP,					/* arrd --> sbp */
	SA_MGMT_WBEM_RESP,					/* BP --> CP 	*/
	SA_MGMT_MOF_RESP,					/* BP --> CP 	*/

	SCP_ARR_OP_LAST
} SBP_ARR_MGMT_OP;

/*
 * SAP_NS_MGMT (34) OP Codes
 */
typedef enum _SBP_NS_MGMT_OP {
	SCP_NS_HELLO_REQ			= 41,	/* ns <-- sbp */
	SCP_NS_HELLO_RSP,					/* ns --> sbp */
	SCP_NS_TEST_REQ,					/* ns <-- sbp */
	SCP_NS_TEST_RSP,					/* ns --> sbp */
	GNN_DAP_REQ,
	GNN_DAP_RSP,
	GSPN_DAP_REQ,
	GSPN_DAP_RSP,
	GDAP_PN_REQ,
	GDAP_PN_RSP,
	GDAP_FT_REQ,
	GDAP_FT_RSP,
	GPN_FT_REQ,
	GPN_FT_RSP,
	GDAPOBJ_DAP_REQ,
	GDAPOBJ_DAP_RSP,
	CMD_REJECT,
	CMD_RSCN,
	ZS_ADD_ZONE_REQ,
	ZS_REMOVE_ZONE_REQ,
	ZS_COMMIT_REQ,
	ZS_ADD_ZONE_RSP,
		ZS_REMOVE_ZONE_RSP,
		ZS_COMMIT_RSP,
	ZS_QUERY_ZONE_REQ,
	ZS_QUERY_ZONE_RSP,
	SCP_NS_OP_LAST
} SBP_NS_MGMT_OP;

typedef enum _SaP_SCP_SBP_MGMT {
	SBP_CP_FAILOVER_MSG			= 41,
	SBP_CONNECTION_RESTORED
} SAP_SCP_SBP_MGMT_OP;

/*
 * SAP_EVM_MGMT (35) OP Codes
 */
typedef enum _SBP_EVM_MGMT {
	SCP_EVM_HELLO_REQ			= 41,
	SCP_EVM_HELLO_RSP,
	SCP_EVM_TEST_REQ,
	SCP_EVM_TEST_RSP,
	SA_MGMT_EVENT_MESSAGE,				/* BP --> CP	*/

	SCP_EVM_OP_LAST
} SBP_EVM_MGMT;


/*
 * SAP_DCE_BLDRV_MGMT OPCODES
 */
typedef enum {
	DCEBLDRV_MGMT_REQ = 41,
	DCEBLDRV_MGMT_RSP,

	OP_DCEBLDRV_LAST
} OP_DCEBLDRV;

/*
 * SAP_CVLM_MGMT (36) OP Codes
 */
typedef enum _SAP_CVLM_MGMT_OP {
	CVLM_BLD_HELLO_REQ			= 41, 	/* CVLC -> CVLM */
	CVLM_BLD_HELLO_RSP,					/* CVLM -> CVLC */
	CVLM_BLD_VERSION_REQ,				/* CVLC -> CVLM */
	CVLM_BLD_VERSION_RSP,				/* CVLM -> CVLC */
	CVLM_BLD_DIST_START_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_DIST_START_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_DIST_COMP_REQ,				/* CVLM -> CVLC */
	CVLM_BLD_DIST_COMP_RSP,				/* CVLC -> CVLM */
	CVLM_BLD_EE_ONLINE,					/* CVLM -> CVLC */
	CVLM_BLD_EE_OFFLINE,				/* CVLM -> CVLC */
	CVLM_BLD_EE_NODE_UPDATE,			/* CVLM -> CVLC */
	CVLM_BLD_DEK_CLUSTER_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_DEK_CLUSTER_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_DEK_CLUSTER_UPDATE_REQ,	/* CVLM -> CVLC */
	CVLM_BLD_DEK_CLUSTER_UPDATE_RSP,	/* CVLC <- CVLM */
	CVLM_BLD_START_HOST_TARGET,			/* CVLM -> CVLC */
	CVLM_BLD_FAILOVER_REQ,				/* CVLM -> CVLC */
	CVLM_BLD_FAILOVER_RSP,				/* CVLC -> CVLM */
	CVLM_BLD_FAILBACK_REQ,				/* CVLM -> CVLC */
	CVLM_BLD_FAILBACK_RSP,				/* CVLC -> CVLM */
	CVLM_BLD_EVENT_GET_REQ,				/* CVLM -> CVLC */
	CVLM_BLD_EVENT_GET_RSP,				/* CVLC -> CVLM */
	CVLM_BLD_EVENT_UPDATE,				/* CVLC -> CVLM */
	CVLM_BLD_DBG_GET_REQ,				/* CVLM -> CVLC */
	CVLM_BLD_DBG_GET_RSP,				/* CVLC -> CVLM */
	CVLM_BLD_PROXY_UPDATE,				/* CVLM -> CVLC */
	CVLM_BLD_LOCK_REQ,					/* CVLM -> CVLC */
	CVLM_BLD_LOCK_RSP,					/* CVLC -> CVLM */
	CVLM_BLD_UNLOCK,					/* CVLM -> CVLC */
	CVLM_BLD_CFG_STATUS_UPDATE,			/* CVLM -> CVLC */
	CVLM_BLD_SESSION_GET_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_SESSION_GET_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_SESS_STATS_RESET_REQ,		/* CVLM -> CVLC */
	CVLM_BLD_SESS_STATS_RESET_RSP,		/* CVLC -> CVLM */
	CVLM_BLD_LUN_DISCOVERY_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_LUN_DISCOVERY_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_MANUAL_REKEY_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_MANUAL_REKEY_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_CT_FAILBACK_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_CT_FAILBACK_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_HOST_TARGET_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_HOST_TARGET_RSP,			/* CVLC -> CVLM */
	CVLM_BLD_HOST_TARGET_PER_EE_REQ,	/* CVLM -> CVLC */
	CVLM_BLD_HOST_TARGET_PER_EE_RSP,	/* CVLC -> CVLM */
    CVLM_BLD_DEVICE_DECOMMISSION_REQ,   /* CVLM -> CVLC */
    CVLM_BLD_DEVICE_DECOMMISSION_RSP,   /* CVLC <- CVLM */
    CVLM_BLD_GET_DECOMMISSIONED_KEYIDS_REQ,    /* CVLM -> CVLC */
    CVLM_BLD_GET_DECOMMISSIONED_KEYIDS_RSP,    /* CVLC -> CVLM */
    CVLM_BLD_REFRESH_DEK_REQ,           /* CVLM -> CVLC */
    CVLM_BLD_REFRESH_DEK_RSP,           /* CVLC -> CVLM */
	CVLM_MMI_CREATE_REQ,
	CVLM_MMI_DELETE_REQ,
	CVLM_MMI_SET_REQ,
	CVLM_MMI_MSET_REQ,
#ifdef SECURE_TAPE_EXPORT_ENABLE
	CVLM_BLD_SECURE_TAPE_EXPORT_REQ,        /* CVLM -> CVLC */                           
	CVLM_BLD_SECURE_TAPE_EXPORT_RSP,        /* CVLC -> CVLM */ 	
#endif /* SECURE_TAPE_EXPORT_ENABLE */
#ifdef SECURE_ERASE_ENABLE
	CVLM_BLD_SECURE_ERASE_REQ,			/* CVLM -> CVLC */
	CVLM_BLD_SECURE_ERASE_RSP,			/* CVLC -> CVLM */
    CVLM_BLD_SE_FEATURE_ENABLE_DISABLE_REQ,
    CVLM_BLD_SE_FEATURE_ENABLE_DISABLE_RSP,
#endif
	CVLM_BLD_DEK_CLUSTER_ADD_REQ,
	CVLM_BLD_DEK_CLUSTER_ADD_RSP,
	CVLM_BLD_LAST
} SAP_CVLM_MGMT_OP;

/*
 * SAP_CVLC_MGMT (37) OP Codes
 */
typedef enum _SAP_CVLC_MGMT_OP {
	CVLC_DEK_CLUSTER_UPDATE = 41,		/* 41 CVLC -> CVLM */
	CVLC_CFG_DIST_COMP,					/* 42 CVLC <-> CVLC */
	CVLC_DBG_CMD,						/* 43 DBG CLI -> CVLC */
	CVLC_DEV_SCN,						/* 44 CVLC -> rekey/tape, cvlc_dev_scn_t */
	CVLC_EE_SCN,						/* 45 CVLC -> rekey/tape, cvlc_ee_scn_t */
	CVLC_SWITCH_SCN,					/* 46 CVLC -> rekey/tape */
	CVLC_DBG_GET_REQ,					/* 47 CVLC -> rekey/tape, cvlc_dbg_info_req_t */
	CVLC_DBG_GET_RSP,					/* 48 CVLC <- rekey/tape, cvlc_dbg_info_rsp_t */
	CVLC_APP_PRT_GRP_UPD,				/* 49 cvlc->rekey/tape */
	CVLC_DEK_CLUSTER_REMOVE,			/* 50 CVLC -> CVLM */
	CVLC_BLD_DEK_CLUSTER_REMOVE,		/* 51 CVLM -> CVLC */
	CVLC_ZONE_CHANGE_SCN,				/* 52 CVLM -> CVLC */
	CVLC_FWD_FC_FRAME_REQ,				/* 53 CVLC <- rekey, cvlc_forward_fc_frame_req_t */
	CVLC_FWD_FC_FRAME_RSP,				/* 54 CVLC -> rekey, cvlc_forward_fc_frame_rsp_t */
	CVLC_BLD_STOP_HOST_TGT,				/* 55 CVLM -> CVLC */
	CVLC_SWITCH_OFFLINE_SCN,			/* 56 CVLM -> CVLC */
	CVLC_DOMAIN_VALID_SCN,				/* 57 CVLM -> CVLC */
	CVLC_LUN_ENABLE_REQ,				/* 58 CVLM -> CVLC */
	CVLC_LUN_ENABLE_RSP,				/* 59 CVLM <- CVLC */
	CVLC_BLD_FAILOVER_GET_REQ,			/* 60 CVLM -> CVLC */
	CVLC_BLD_FAILOVER_GET_RSP,			/* 61 CVLM <- CVLC */
	CVLC_BLD_FCR_DOMAIN_UPDATE,			/* 62 CVLM -> CVLC */
	CVLC_BLD_VTVI_REBALANCE_REQ,		/* 63 CVLM -> CVLC */
	CVLC_BLD_VTVI_REBALANCE_RSP,		/* 64 CVLM <- CVLC */
	CVLC_BLD_REBALANCE_REQ,		        /* 65 CVLM -> CVLC */
	CVLC_BLD_REBALANCE_RSP,		        /* 66 CVLM <- CVLC */
	CVLC_BLD_CHECK_REBALANCE_REQ,       /* 67 CVLM -> CVLC */
	CVLC_BLD_CHECK_REBALANCE_RSP,       /* 68 CVLM <- CVLC */
	CVLC_BLD_GET_MEDIA_TYPE_REQ,		/* 69 CVLM -> CVLC */
	CVLC_BLD_GET_MEDIA_TYPE_RSP,		/* 70 CVLM <- CVLC */
#ifdef SECURE_ERASE_ENABLE
	CVLC_FWD_SE_FC_FRAME_REQ,			/* 71 CVLC <- LUNerase, cvlc_forward_fc_frame_req_t */
#endif
	CVLC_MGMT_OP_LAST
} SAP_CVLC_MGMT_OP;

/*
 * SAP_REKEY_MGMT (38) OP Codes
 */
typedef enum _SAP_REKEY_MGMT_OP {
	RK_START_REKEY_REQ = 41,		/* 41 CVLC -> rekey, cvlc_rekey_init_tgt_t */
	RK_START_REKEY_ACK,				/* 42 CVLC <- rekey, cvlc_rekey_ack_t */
	RK_REKEY_COMPLETED,				/* 43 CVLC <- rekey, cvlc_rekey_done_t */
	RK_PAUSE_REKEY_REQ,				/* 44 CVLC -> rekey */
	RK_PAUSE_REKEY_RSP,				/* 45 CVLC <- rekey */
	RK_DELETE_REKEY_REQ,			/* 46 CVLC -> rekey, cvlc_del_rekey_t */
	RK_DELETE_REKEY_RSP,			/* 47 CVLC <- rekey, cvlc_del_rekey_rsp_t */
	RK_RESUME_SUSPENDED_REKEY,		/* 48 CVLC <- rekey */
	RK_KEY_PROPERTY_UPDATE_REQ,		/* 49 CVLC <- rekey, cvlc_key_property_update_t */
	RK_KEY_PROPERTY_UPDATE_RSP,		/* 50 CVLC -> rekey, cvlc_key_property_update_rsp_t */
	RK_GET_PID_REQ,					/* 51 CVLC <- rekey, cvlc_get_pid_req_t */
	RK_GET_PID_RSP,					/* 52 CVLC -> rekey, cvlc_get_pid_rsp_t*/
	RK_GET_DEK_CLUSTER_REQ,			/* 53 CVLC <- rekey, cvlc_dek_cluster_req_t */
	RK_GET_DEK_CLUSTER_RSP,			/* 54 CVLC -> rekey, cvlc_dek_cluster_rsp_t */
	RK_FWD_FC_FRAME_REQ,			/* 55 CVLC -> rekey, cvlc_forward_fc_frame_req_t */
	RK_FWD_FC_FRAME_RSP,			/* 56 CVLC <- rekey, cvlc_forward_fc_frame_rsp_t */
	RK_GET_REKEY_STATUS_REQ,		/* 57 CVLC -> rekey, cvlc_get_rekey_sts_req_t */
	RK_GET_REKEY_STATUS_RSP,		/* 58 CVLC <- rekey, cvlc_get_rekey_sts_rsp_t */
	RK_GET_REKEY_STATS_REQ,			/* 59 CVLC -> rekey */
	RK_GET_REKEY_STATS_RSP,			/* 60 CVLC <- rekey */
	RK_RESET_REKEY_STATS_REQ,		/* 61 CVLC -> rekey */
	RK_RESET_REKEY_STATS_RSP,		/* 62 CVLC <- rekey */
	RK_DBG_CMD,						/* 63 DBG CLI -> rekey */
	RK_HA_TBL_UPDATE_REQ,			/* 64 CVLC -> rekey, cvlc_ha_cluster_update_req_t */
	RK_HA_TBL_UPDATE_RSP,			/* 65 CVLC <- rekey, cvlc_ha_cluster_update_rsp_t */
	RK_POLICY_UPDATE_REQ,			/* 66 CVLC -> rekey, cvlc_policy_update_req_t */
	RK_POLICY_UPDATE_RSP,			/* 67 CVLC <- rekey, cvlc_policy_update_rsp_t */
	RK_REMOTE_REKEY_STARTED,		/* 68 CVLC <- rekey, cvlc_rekey_started_lun_t */
	RK_RESUME_REKEY_REQ,			/* 69 CVLC -> rekey, cvlc_res_rekey_t */
	RK_RESUME_REKEY_RSP,			/* 70 CVLC <- rekey, cvlc_res_rekey_rsp_t */
	RK_DEK_CLUSTER_UPDATE,			/* 71 CVLC -> rekey, cvlc_dek_cluster_t */
	REKEY_MGMT_OP_LAST
} SAP_REKEY_MGMT_OP;

/*
 * SAP_SECURE_ERASE_MGMT (58) OP Codes
 */

#ifdef SECURE_ERASE_ENABLE
typedef enum _SAP_SECURE_ERASE_MGMT_OP {
	SE_START_SECURE_ERASE_REQ = 41,		/* 41 CVLC -> secure_erase, cvlc_rekey_init_tgt_t */
	SE_START_SECURE_ERASE_ACK,				/* 42 CVLC <- secure_erase, cvlc_rekey_ack_t */
	SE_SECURE_ERASE_COMPLETED,				/* 43 CVLC <- secure_erase, cvlc_rekey_done_t */
	SE_PAUSE_SECURE_ERASE_REQ,				/* 44 CVLC -> secure_erase */
	SE_PAUSE_SECURE_ERASE_RSP,				/* 45 CVLC <- secure_erase */
	SE_DELETE_SECURE_ERASE_REQ,			/* 46 CVLC -> secure_erase, cvlc_del_rekey_t */
	SE_DELETE_SECURE_ERASE_RSP,			/* 47 CVLC <- secure_erase, cvlc_del_rekey_rsp_t */
	SE_RESUME_SUSPENDED_SECURE_ERASE,		/* 48 CVLC <- secure_erase */
	SE_KEY_PROPERTY_UPDATE_REQ,		/* 49 CVLC <- secure_erase, cvlc_key_property_update_t */
	SE_KEY_PROPERTY_UPDATE_RSP,		/* 50 CVLC -> secure_erase, cvlc_key_property_update_rsp_t */
	SE_GET_PID_REQ,					/* 51 CVLC <- secure_erase, cvlc_get_pid_req_t */
	SE_GET_PID_RSP,					/* 52 CVLC -> secure_erase, cvlc_get_pid_rsp_t*/
	SE_GET_DEK_CLUSTER_REQ,			/* 53 CVLC <- secure_erase, cvlc_dek_cluster_req_t */
	SE_GET_DEK_CLUSTER_RSP,			/* 54 CVLC -> secure_erase, cvlc_dek_cluster_rsp_t */
	SE_FWD_FC_FRAME_REQ,			/* 55 CVLC -> secure_erase, cvlc_forward_fc_frame_req_t */
	SE_FWD_FC_FRAME_RSP,			/* 56 CVLC <- secure_erase, cvlc_forward_fc_frame_rsp_t */
	SE_GET_SECURE_ERASE_STATUS_REQ,		/* 57 CVLC -> secure_erase, cvlc_get_rekey_sts_req_t */
	SE_GET_SECURE_ERASE_STATUS_RSP,		/* 58 CVLC <- secure_erase, cvlc_get_rekey_sts_rsp_t */
	SE_GET_SECURE_ERASE_STATS_REQ,			/* 59 CVLC -> secure_erase */
	SE_GET_SECURE_ERASE_STATS_RSP,			/* 60 CVLC <- secure_erase */
	SE_RESET_SECURE_ERASE_STATS_REQ,		/* 61 CVLC -> secure_erase */
	SE_RESET_SECURE_ERASE_STATS_RSP,		/* 62 CVLC <- secure_erase */
	SE_DBG_CMD,						/* 63 DBG CLI -> secure_erase */
	SE_HA_TBL_UPDATE_REQ,			/* 64 CVLC -> secure_erase, cvlc_ha_cluster_update_req_t */
	SE_HA_TBL_UPDATE_RSP,			/* 65 CVLC <- secure_erase, cvlc_ha_cluster_update_rsp_t */
	SE_POLICY_UPDATE_REQ,			/* 66 CVLC -> secure_erase, cvlc_policy_update_req_t */
	SE_POLICY_UPDATE_RSP,			/* 67 CVLC <- secure_erase, cvlc_policy_update_rsp_t */
	SE_REMOTE_SECURE_ERASE_STARTED,		/* 68 CVLC <- secure_erase, cvlc_rekey_started_lun_t */
	SE_RESUME_SECURE_ERASE_REQ,			/* 69 CVLC -> secure_erase, cvlc_res_rekey_t */
	SE_RESUME_SECURE_ERASE_RSP,			/* 70 CVLC <- secure_erase, cvlc_res_rekey_rsp_t */
	SE_DEK_CLUSTER_UPDATE,			/* 71 CVLC -> secure_erase, cvlc_dek_cluster_t */
	SECURE_ERASE_MGMT_OP_LAST
} SAP_SECURE_ERASE_MGMT_OP;
#endif
/*
 * Messages received by crypto tape, definitions in
 * bfos/include/macs/cvlc_msg.h
 */
typedef enum _SAP_CTAPE_MGMT_OP {
	CTAPE_INIT_NEXUS_REQ = 41,		/* CVLC -> tape, tape_init_nexus_req_t */
	CTAPE_INIT_NEXUS_RSP = 42,		/* CVLC <- tape, tape_init_nexus_rsp_t */
	CTAPE_CLEAR_NEXUS_REQ = 43,		/* CVLC -> tape, tape_clr_nexus_req_t */
	CTAPE_CLEAR_NEXUS_RSP = 44,		/* CVLC <- tape, tape_clr_nexus_rsp_t */
	CTAPE_POLICY_SET_REQ = 45,		/* CVLC -> tape, tape_set_policy_t */
	CTAPE_POLICY_SET_RSP = 46,		/* CVLC <- tape, tape_set_policy_rsp_t */
	CTAPE_LUN_POLICY_SET_REQ = 47,	/* CVLC -> tape, tape_lun_policy_update_req_t */
	CTAPE_LUN_POLICY_SET_RSP = 48,	/* CVLC <- tape, tape_lun_policy_update_rsp_t */
	CTAPE_STAT_GET_REQ = 49,		/* CVLC -> tape, tape_get_stat_t */
	CTAPE_STAT_GET_RSP = 50,		/* CVLC <- tape, tape_stat_rsp_t */
	CTAPE_FWD_FC_FRAME_REQ = 51,	/* CVLC -> tape, cvlc_forward_fc_frame_req_t */
	CTAPE_FWD_FC_FRAME_RSP = 52,	/* CVLC <- tape, cvlc_forward_fc_frame_rsp_t */
	CTAPE_DB_DIST_REQ = 53,			/* CVLC -> tape, tape_db_dist_req_t */
	CTAPE_DB_DIST_RSP = 54,			/* CVLC <- tape, tape_db_dist_rsp_t */
	CTAPE_WRONG_DEV_TYPE = 55,		/* CVLC <- tape, tape_wrong_dev_type_t */
	CTAPE_POOL_STAT_REQ = 56,		/* CVLC -> tape, tape_pool_stat_req_t */
	CTAPE_POOL_STAT_RSP = 57,		/* CVLC <- tape, tape_pool_stat_rsp_t */
	CTAPE_COPY_CACHE_FILE_REQ = 58, /* CVLC -> tape, tape_copy_cache_file_req_t */
	CTAPE_COPY_CACHE_FILE_RSP = 59, /* CVLC <- tape, tape_copy_cache_file_rsp_t */
	CTAPE_LUN_DISC_REQ = 60,		/* CVLC -> tape, tape_lun_disc_req_t */
	CTAPE_LUN_DISC_RSP = 61,		/* CVLC <- tape, tape_lun_disc_rsp_t */
	CTAPE_DEV_NOT_EXIST = 62,		/* CVLC <- tape, device does not exist or offline*/

	/*
	 * "CTAPE_DRV" - between tape driver and tape.  No real XBAR/CSCN subscription
	 * is done for these.  Requests are "up" from driver to user-sapce module.
	 *
	 * Structures are in bfos/include/mace/tape_drv_msg.h
	 */
	CTAPE_DRV_GET_DEK_REQ = 63,		/* TapeDrv -> tape, dek_get_dek() request*/
	CTAPE_DRV_GET_DEK_RSP = 64,		/* TapeDrv <- tape, dek_get_dek() response */
	CTAPE_DRV_CREATE_DEK_REQ = 65,	/* TapeDrv -> tape, dek_create_dek() request*/
	CTAPE_DRV_CREATE_DEK_RSP = 66,	/* TapeDrv <- tape, dek_create_dek() response */ 
	CTAPE_DRV_INJECT_DEK_REQ = 67,	/* TapeDrv -> tape, dek_inject_dek() request*/
	CTAPE_DRV_INJECT_DEK_RSP = 68,	/* TapeDrv <- tape, dek_inject_dek() response */ 

	CTAPE_DRV_ABORT_TRAN_REQ = 69,	/* TapeDrv -> tape, dek_abort_tran() request*/
	CTAPE_DRV_ABORT_TRAN_RSP = 70,	/* TapeDrv <- tape, dek_abort_tran() response */ 
	CTAPE_DRV_CREATE_POOL_RSP= 71,	/* TapeDrv <- tape, tape_dek_xbar_tape_pool_create_resp*/  
	CTAPE_DRV_FFDC = 72,			/* TapeDrv -> tape, internal raslog has hit;
									 * save private trace */
	

	/*
	 * IOCTL's from tape daemon to tape driver.
	 *
	 * Structures are in bfos/include/mace/tape_drv_mtrace.h
	 */
	CTAPE_DRVR_MTRACE_IOCTL = 73,		/* Media trace IOCTL */
	CTAPE_STAT_CLR_REQ 		= 74,		/* CVLC -> tape, tape_get_stat_t */
	CTAPE_STAT_CLR_RSP 		= 75,		/* CVLC <- tape, tape_stat_rsp_t */
	CTAPE_DRVR_LUN_TRACE_IOCTL = 76,

#ifdef SECURE_TAPE_EXPORT_ENABLE	          
	/*  
	* Secure Tape export OP between CVLC, TAPED, and Tape kernel
	*/
	       
	CTAPE_SECURE_TAPE_EXPORT_REQ = 76,
	CTAPE_SECURE_TAPE_EXPORT_KEY_ID_REQ = 77,
	CTAPE_SECURE_TAPE_EXPORT_RSP = 78,
#endif /* SECURE_TAPE_EXPORT_ENABLE */

	/* more to come ... */
	CTAPE_MGMT_OP_LAST
} SAP_CTAPE_MGMT_OP;

/*
 * SAP_LANCE_BLDRV_MGMT OPCODES
 */
typedef enum {
	LBDRV_MGMT_REQ = 41,
	LBDRV_MGMT_RSP,
	LBDRV_MGMT_PGRP_UP,
	LBDRV_MGMT_PGRP_DOWN,
	LBDRV_MGMT_BLADE_ONLINE,
	LBDRV_MGMT_BLADE_OFFLINE,

	OP_LBDRV_LAST
} OP_LBDRV;

/*
 * SAP_LANCE_SP_MGMT OP Codes
 */
typedef enum {
	LANCE_SP_MGMT_OP_SVCS			= 41,
	LANCE_SP_MGMT_OP_USER,
	LANCE_SP_MGMT_OP_LPC_USER,
	LANCE_SP_MGMT_OP_LAST
} LANCE_SP_MGMT_OP;

/*
 * SAP_LANCE_DEK_MGMT OP Codes
 */
typedef enum {
	LANCE_DEK_MGMT_OP_SVCS			= 41,
	LANCE_DEK_MGMT_OP_CVLC_USER,
	LANCE_DEK_MGMT_OP_TAPE_USER,
	LANCE_DEK_MGMT_OP_LAST
} LANCE_DEK_MGMT_OP;

/*
 * SAP_LANCE_KEK_MGMT OP Codes
 */
typedef enum {
	LANCE_KEK_MGMT_OP_SVCS			= 41,
	LANCE_KEK_MGMT_OP_EE_USER,
	LANCE_KEK_MGMT_OP_LAST
} LANCE_KEK_MGMT_OP;

/*
 * SAP_LANCE_KEY_VAULT OP Codes
 */
typedef enum {
	LANCE_KEY_VAULT_OP_SVCS			= 41,
	LANCE_KEY_VAULT_OP_CVLC_USER,
	LANCE_KEY_VAULT_OP_TAPE_USER,
	LANCE_KEY_VAULT_OP_LAST
} LANCE_KEY_VAULT_OP;

/*
 * SAP_LANCE_EE_MGMT OP Codes
 */
typedef enum {
	LANCE_EE_MGMT_OP_SVCS			= 41,
	LANCE_EE_MGMT_OP_CVLC_USER,
	LANCE_EE_MGMT_OP_TAPE_USER,
	LANCE_EE_MGMT_OP_LAST
} LANCE_EE_MGMT_OP;

/*
 * SAP_CNM_MGMT (46) OP Codes
 */
typedef enum _SAP_CNM_MGMT_OP {
	CNM_BLD_HELLO_REQ			= 41, 	/* CVLC -> CNM */
	CNM_BLD_HELLO_RSP,					/* CNM -> CVLC */
	CNM_BLD_VERSION_REQ,				/* CVLC -> CNM */
	CNM_BLD_VERSION_RSP,				/* CNM -> CVLC */
	CNM_BLD_DIST_START_REQ,			/* CNM -> CVLC */
	CNM_BLD_DIST_START_RSP,			/* CVLC -> CNM */
	CNM_BLD_DIST_COMP_REQ,				/* CNM -> CVLC */
	CNM_BLD_DIST_COMP_RSP,				/* CVLC -> CVLM */
	CNM_BLD_EE_ONLINE,					/* CNM -> CVLC */
	CNM_BLD_EE_OFFLINE,				/* CNM -> CVLC */
	CNM_BLD_EE_NODE_UPDATE,			/* CNM -> CVLC */
	CNM_BLD_DEK_CLUSTER_REQ,			/* CNM -> CVLC */
	CNM_DEK_CLUSTER_RSP,			/* CVLC -> CNM */
	CNM_BLD_DEK_CLUSTER_UPDATE,		/* CNM -> CVLC */
	CNM_BLD_START_HOST_TARGET,			/* CNM -> CVLC */
	CNM_BLD_FAILOVER_REQ,				/* CNM -> CVLC */
	CNM_BLD_FAILOVER_RSP,				/* CVLC -> CNM */
	CNM_BLD_FAILBACK_REQ,				/* CNM -> CVLC */
	CNM_BLD_FAILBACK_RSP,				/* CVLC -> CNM */
	CNM_BLD_EVENT_GET_REQ,				/* CNM -> CVLC */
	CNM_BLD_EVENT_GET_RSP,				/* CVLC -> CNM */
	CNM_BLD_EVENT_UPDATE,				/* CVLC -> CNM */
	CNM_BLD_DBG_GET_REQ,				/* CNM -> CVLC */
	CNM_BLD_DBG_GET_RSP,				/* CVLC -> CNM */
	CNM_BLD_PROXY_UPDATE,				/* CNM -> CVLC */
	CNM_BLD_LOCK_REQ,					/* CNM -> CVLC */
	CNM_BLD_LOCK_RSP,					/* CVLC -> CNM */
	CNM_BLD_UNLOCK,					/* CNM -> CVLC */
	CNM_BLD_CFG_STATUS_UPDATE,			/* CNM -> CVLC */
	CNM_BLD_SESSION_GET_REQ,			/* CNM -> CVLC */
	CNM_BLD_SESSION_GET_RSP,			/* CVLC -> CNM */
	CNM_BLD_SESS_STATS_RESET_REQ,		/* CNM -> CVLC */
	CNM_BLD_SESS_STATS_RESET_RSP,		/* CVLC -> CNM */
	CNM_BLD_LUN_DISCOVERY_REQ,			/* CNM -> CVLC */
	CNM_BLD_LUN_DISCOVERY_RSP,			/* CVLC -> CNM */
	CNM_BLD_MANUAL_REKEY_REQ,			/* CNM -> CVLC */
	CNM_BLD_MANUAL_REKEY_RSP,			/* CVLC -> CNM */
	CNM_MMI_CREATE_REQ,
	CNM_MMI_DELETE_REQ,
	CNM_MMI_SET_REQ,
	CNM_MMI_MSET_REQ,
	CNM_BLD_LAST
} SAP_CNM_MGMT_OP;


 /*
  * SAP_LANCE_SP_INIT_MGMT OP Codes
  */
typedef enum {
	LANCE_SP_INIT_MGMT_OP_SVCS			= 41,
	LANCE_SP_INIT_MGMT_OP_USER,
	LANCE_SP_INIT_MGMT_OP_LPC_USER,
	LANCE_SP_INIT_MGMT_OP_LAST
} LANCE_SP_INIT_MGMT_OP;

 /*
  * SAP_LANCE_BC_MGMT OP Codes
  */
typedef enum {
	SAP_LANCE_BC_MGMT_OP_SVCS			= 41,
	SAP_LANCE_BC_MGMT_OP_USER,
	SAP_LANCE_BC_MGMT_OP_LAST
} SAP_LANCE_BC_MGMT_OP;

 /*
  * SAP_LANCE_OP_EVT_MGMT OP Codes
  */
typedef enum {
	LANCE_OP_EVT_LINK_EVT_CLIENT			= 41,
	LANCE_OP_EVT_CHIP_STARTED,
	LANCE_OP_EVT_LAST
} LANCE_OP_EVT_OP;

typedef enum _SBP_SAS_MGMT_OP{ 
	SCP_SAS_HELLO_REQ			= 41,  /* ns <-- sbp */
	SCP_SAS_HELLO_RSP,
	FCR_REQ_DOM_EVENT,
	FCR_ADD_DOM_EVENT,
	FCR_REMOVE_DOM_EVENT,
	FCR_GET_DOM_LIST,
	FCR_GET_DOM_LIST_RSP,
	FCR_OP_LAST
} SBP_SAS_MGMT_OP;

#endif	/* _SAP_OP_H */
