#!/bin/sh
# Copyright (c) 2002-2006 by Brocade Communications Systems, Inc.
# All rights reserved.
#
# Module name: pdshow.sh
#
# Description:
#	Panic dump show
#
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin
TMPFILE=/tmp/catconsole.${PPID}.${RANDOM}
BIN=/fabos/cliexec/

/bin/ln -s /fabos/cliexec/lscfg_util /usr/sbin/lscfg_test 2> /dev/null

# Check RBAC permission on command
/fabos/libexec/rbac_check `/bin/basename $0`

if [ $? -ne 0 ]; then
 	printf " RBAC failed , exiting pdshow "	
    exit 127
fi

# different known platforms
ULY=Ulysses
WARP=Warp
TERM=Terminator
METEOR=Meteor
BLAZER=Blazer
PULSAR=Pulsar
DAZZLER=Dazzler
DAZZLERJR=Dazzlerjr
BLAZEROEM=BlazerOEM
PULSAR32=Pulsar-32
ICECUBE=IceCube
GLACIER=Glacier
STEALTH=Stealth
SATURN=Saturn
UNKNOWN=Unknown

#
# function to clean temporary files
#
pdCleanUpFiles()
{
	rm -f ${TMPFILE} 1>/dev/null 2>/dev/null
}
setcontext()
{
    if [ "$1" != "chassis" ]
    then    
        eval `/fabos/cliexec/lscfg_util --switch $1`
    else    
        eval `/fabos/cliexec/lscfg_util --chassis`
    fi
}

cmd_iterate_all() {
  NUM_SW_INSTANCE=`lscfg_test --max`
  CUR_SW_INST=0
  while [ $CUR_SW_INST -le $NUM_SW_INSTANCE ]
  do
    FABID=`lscfg_test --fid $CUR_SW_INST`

    if [ $FABID -ne -1 ]
    then
      setcontext $FABID
       printf "CURRENT CONTEXT -- $CUR_SW_INST , $FABID \n"
	  
	  printf "=== Portlog for switch $CUR_SW_INST and FID $FABID\n"
	  PL="pl.$CUR_SW_INST"
	  /bin/cp $1 /tmp/$PL
	  $BIN/portlogdump 
	  printf "=== Persistent Portlog for switch $CUR_SW_INST and FID $FABID\n"
	  /bin/cp $1 /tmp/$PL
	  $BIN/portlogdump 0,1
	 
	  printf "== switch info for switch $CUR_SW_INST , FID $FABID\n"
	  SW="sw.$CUR_SW_INST"
	  /bin/cp $1 /tmp/$SW
	  $BIN/objectdump < $1
    fi
    CUR_SW_INST=`expr $CUR_SW_INST + 1`
  done
}


#
# get the platform name
#
# Uses value of $PLATFORM
# returns value in platform_name
#
getPlatformName() {
	if [ "$PLATFORM" = "10" ]
	then
		platform_name=$ULY
		return
	fi
	if [ "$PLATFORM" = "11" ]
	then
		platform_name=$WARP
		return
	fi
	if [ "$PLATFORM" = "12" ]
	then
		platform_name=$TERM
		return
	fi
	if [ "$PLATFORM" = "21" ]
	then
		platform_name=$METEOR
		return
	fi
	if [ "$PLATFORM" = "22" ]
	then
		platform_name=$BLAZER
		return
	fi
	if [ "$PLATFORM" = "23" ]
	then
		platform_name=$PULSAR
		return
	fi
	if [ "$PLATFORM" = "26" ]
	then
		platform_name=$DAZZLER
		return
	fi
	if [ "$PLATFORM" = "27" ]
	then
		platform_name=$DAZZLERJR
		return
	fi
	if [ "$PLATFORM" = "28" ]
	then
		platform_name=$BLAZEROEM
		return
	fi
	if [ "$PLATFORM" = "32" ]
	then
		platform_name=$PULSAR32
		return
	fi
	if [ "$PLATFORM" = "34" ]
	then
		platform_name=$STEALTH
		return
	fi
	if [ "$PLATFORM" = "42" ]
	then
		platform_name=$SATURN
		return
	fi
        if [ "$PLATFORM" = "29" ]
        then
                platform_name=$ICECUBE
                return
        fi
        if [ "$PLATFORM" = "33" ]
        then
                platform_name=$GLACIER
                return
        fi
	platform_name=$UNKNOWN
}

#
# get the platform on which this script is running
#

getHostPlatform() {

#
# get the current platform
#
	PLATFORM=$[`sin 2>/dev/null | awk '/SWBD/ { print $2 }' | sed 's/[^0-9]//g'`]

	getPlatformName

	if [ "$platform_name" != "$UNKNOWN" ]
	then
		host_platform="$platform_name"
	else
		host_platform="Unknown"
	fi
}


# Function used to get the platform from the pd file
# arg1: pd file
#
getPdPlatform() {
	$BIN/pdex $1 PD_MISC > ${TMPFILE}
#	/bin/cat ${TMPFILE} | while :
#	do
#		read thisLine
#		if [ -z "$thisLine" ]
#		then
#			pd_platform="Undefined"
#			return
#		fi
#		rc=`/bin/grep -c "^sin=Platform:"`
#		[ $rc -ne 0 ] && break;
#	done
	thisLine=`/bin/grep -a SWBD ${TMPFILE}`
	PLATFORM=`echo $thisLine | /bin/grep -a SWBD | /usr/bin/cut -d ' ' -f 2 | \
			/usr/bin/cut -c5-6`
        if [ "$PLATFORM" = "" ]
        then
                pd_platform="Not Defined in pd file"
                return
        fi
	getPlatformName

	if [ "$platform_name" != "$UNKNOWN" ]
	then
		pd_platform="$platform_name"
		return
	fi
	pd_platform="Unknown"
	printf "Unknown platform from pdfile: '$PLATFORM'\n"
}

checkPlatform() {
	getHostPlatform
	getPdPlatform "$1"
	if [ "$pd_platform" = "$host_platform" ]
	then
		printf "Platform from pdfile is: $pd_platform\n"
		return
	fi
	printf "
                *** CAUTION ***
  *  Host  PLATFORM  (current) is: '$host_platform'
  *  PLATFORM got from pd file is: '$pd_platform'
  *  Some results shown may be incorrect and/or missing
  *  It is best if this command is run on same PLATFORM as that of pdfile
               **************
"
}
#
# used to show client's data from and extracted file by pdex
# arg1: is the client name
# arg2: is the client's data (which was extracted from pd file)
# arg3: is the name of the original panicdump file (used for printing only)
#
showClientData() {
printf "
_______________________********________________________
*   File   :%-40.40s  *
*   SECTION:%-40.40s  *
-----------------------********------------------------
" "$3" "$1"

##### return

	case $1 in
	MTRACER)
		/usr/bin/tr -d "\0" < $2
		;;
	PD_MISC)
		/usr/bin/tr -d "\0" < $2
		;;
	CONSOLE_LOG)
		$BIN/catconsole $2
		;;
#	pl.0)
#		printf "=== Portlog for switch 0\n"
#		/bin/cp $2 /tmp/pl.0
#		# setswitch 0
# 		eval `/fabos/bin/diagenv -b writed SWITCH_ENV 0 0`
#		$BIN/portlogdump 0,1
#		;;
#	pl.1)
#		printf "=== Portlog for switch 1\n"
#		/bin/cp $2 /tmp/pl.1
#		# setswitch 1
#		eval `/fabos/bin/diagenv -b writed SWITCH_ENV 0 1`
#		$BIN/portlogdump 0,1
#		;;
	ps)
		cmd_iterate_all $2
		;;
	KERNEL_STACK_DUMP)
		/bin/cp $2 /tmp/kstack
		$BIN/objectdump < $2
		;;
	PLATFORM)
		/bin/cp $2 /tmp/platform_pd
		$BIN/objectdump < $2
		;;
	PLATFORM_FIRST)
		/bin/cp $2 /tmp/platform_pd_first
		$BIN/objectdump < $2
		;;
#	sw.0)
#		/bin/cp $2 /tmp/sw.0
#		$BIN/objectdump < $2
#		;;
#	sw.1)
#		/bin/cp $2 /tmp/sw.1
#		$BIN/objectdump < $2
#		;;
	PANIC_DUMP_LOG)
		/usr/bin/tr -d "\0" < $2
		;;
	*)	# unknown case
		printf "\n\nbug: unknown client name: '$1'\n"
		;;
	esac
}
#
# function to show the contents of just one file
#

# Note that Ulysses is only one that is different
#!/bin/sh
# Copyright (c) 2002-2006 by Brocade Communications Systems, Inc.
#
# arg1: will be the pd file
pdShowOneFile()
{
	if [ -z "$1" ]
	then
		printf "pdShowOneFile: received NULL file\n"
		return
	fi
	checkPlatform $1

	#CLIENT_LIST should be platform dependant
	if [ "$pd_platform" == $ULY ]
	then
		CLIENT_LIST=" PD_MISC CONSOLE_LOG MTRACER PLATFORM_FIRST PLATFORM ps KERNEL_STACK_DUMP"
	else
		CLIENT_LIST=" PD_MISC CONSOLE_LOG MTRACER PLATFORM_FIRST PLATFORM ps KERNEL_STACK_DUMP"
	fi
	for Clients in $CLIENT_LIST
	do
		$BIN/pdex $1 $Clients > ${TMPFILE}
		if [ $? -ne 0 ]
		then
			printf "pdex failed on $1 for $Clients \($?\)\n"
			showClientData "$Clients" "${TMPFILE}" "$1"
		else
			showClientData "$Clients" "${TMPFILE}" "$1"
		fi
		pdCleanUpFiles
	done
}

print_usage()
{
	printf "\
Usage: `/bin/basename $0` [help | <pdfile>]
   no-arguments: use a latest pdfile, if found.
   help:         print this message with a list of available pdfiles
   <pdfile>:     input panic-dump file in panic-dump format
"
	k=`/bin/ls -l /core_files/panic/core.* 2>/dev/null | /usr/bin/wc -l`
	if [ $k -eq 0 ]
	then
		printf "no pdfiles found\n"
	else
		printf "Here is a list of available pd files:\n"
		/bin/ls /core_files/panic/core.* 2>/dev/null | /bin/sed -e ''
	fi
	exit 0
}
currentShow() {
	printf "\n=== Showing CURRENT console log\n"
	$BIN/catconsole /proc/consolelog
	exit 0
}
allShow()
{
	for pdFile in /core_files/panic/core.* /dev/panicdump
	do
		if [ ! -f $pdFile ]
		then
			continue
		fi
		$BIN/pdcp $pdFile # let the errors come out 
		if [ $? -ne 0 ]
		then
			printf "Skipping invalid file $pdFile\n"
			continue
		fi
		pdShowOneFile $pdFile
	done
	currentShow
}
getLatestFile()
{
	latestTs=0
	latestFile=""
	PD_FILES=""
	/bin/ls /core_files/panic/core.* >/dev/null  2>&1 
	if [ $? -eq 0 ]
	then
		PD_FILES="${PD_FILES} /core_files/panic/core.*"
	fi
	/bin/ls /mnt/core_files/panic/core.* >/dev/null  2>&1 
	if [ $? -eq 0 ]
	then
		PD_FILES="${PD_FILES} /mnt/core_files/panic/core.*"
	fi

	for pdFile in $PD_FILES
	do
		$BIN/pdcp $pdFile > /dev/null
		if [ $? -ne 0 ]
		then
			printf "Skipping unrecognized file $pdFile\n"
			continue
		fi
        	ts_full=`$BIN/pdcp $pdFile 2>/dev/null`
        	ts=`echo $ts_full | /usr/bin/cut -f1 -d' '`
		[ -z "$ts" ] && ts=0
		if [ $latestTs -lt $ts ]
		then
			latestTs=$ts
			latestFile=$pdFile
			latestTsFull=$ts_full
		fi
	done
	if [ -z "$latestFile" ]
	then
		printf "Could not find any valid pd file!\n"
		exit 0
	fi
	# printf "Latest file is: $latestFile created on $latestTsFull\n"
}
latestShow() {
	getLatestFile
	# getLatestFile will not return if $latstFile is NULL
	pdShowOneFile $latestFile
}

#
# main starts here
#

if [ $# -eq 0 ]
then
/bin/ln -s /fabos/cliexec/lscfg_util /usr/sbin/lscfg_test 2> /dev/null
	# if no argument is given, we will just show the latest pd
	latestShow
	exit 0
fi
if [ "$1" = "-help" -o "$1" = "help" ]
then
	# some help... atleast
	print_usage
	exit 0
fi

/bin/ln -s /fabos/cliexec/lscfg_util /usr/sbin/lscfg_test 2> /dev/null

# more than one argument given
case  "$1" in
"ALL")
	allShow
	;;
MTD)
	pdShowOneFile /dev/panicdump
	;;
CURRENT)
	currentShow
	;;
LATEST)
	latestShow
	;;
*)
	if [ ! -f "$1" ]
	then
		printf "can not find file: $1\n"
		print_usage
	fi
	pdShowOneFile $1;
esac
/bin/rm -rf /usr/sbin/lscfg_test
