#!/bin/sh
#setup enviroment
CP=cp
MKDIR=mkdir
RM=rm
SPLOG_TMPDIR=/tmp/splogs/
SP_DEBUG_TAR_FILE=/tftpboot/sp/tftp/sp_debug_info.tar
TOUCH=touch
CHMOD=chmod
LS=/bin/ls
DF=/bin/df
CAT=/bin/cat
LOCAL_CERTS_PATH=/etc/fabos/certs/sw0/l/
REMOTE_CERTS_PATH=/etc/fabos/certs/sw0/r/

$TOUCH $SP_DEBUG_TAR_FILE
$CHMOD 777 $SP_DEBUG_TAR_FILE
/fabos/bin/spc_test -c 19
$MKDIR -p $SPLOG_TMPDIR
$CP -f $SP_DEBUG_TAR_FILE $SPLOG_TMPDIR
$CP -f /etc/fabos/mace/spc* $SPLOG_TMPDIR
$RM -f $SP_DEBUG_TAR_FILE

# Capturing generic BP stuff

echo -e "\nFiles in /var/log"
echo -e "-------------------\n"
$LS -l /var/log

echo -e "\nFiles in /tmp"
echo -e "---------------\n"
$LS -l /tmp

echo -e "\nDisk free space"
echo -e "-----------------\n"
$DF -k

if [ -e $LOCAL_CERTS_PATH ]; then
echo -e "\nFiles in /etc/fabos/certs/sw0/l"
echo -e "---------------\n"
$LS -l $LOCAL_CERTS_PATH
 
echo -e "\nData in files in /etc/fabos/certs/sw0/l"
echo -e "---------------\n"
$CAT $LOCAL_CERTS_PATH/*
fi
 
if [ -e $REMOTE_CERTS_PATH ]; then
echo -e "\nFiles in /etc/fabos/certs/sw0/r"
echo -e "---------------\n"
$LS -l $REMOTE_CERTS_PATH
 
echo -e "\nData in files in /etc/fabos/certs/sw0/r"
echo -e "---------------\n"
$CAT $REMOTE_CERTS_PATH/*
fi
 
echo -e "\nFiles in /root"
echo -e "---------------\n"
$LS -l /root

echo -e "\nFiles in /etc/fabos/mace"
echo -e "---------------\n"
$LS -l /etc/fabos/mace

if [ -e /root/.ssh ]; then
echo -e "\nFiles in /root/.ssh"
echo -e "---------------\n"
$LS -l /root/.ssh
 
echo -e "\nData in files in /root/.ssh"
echo -e "---------------\n"
$CAT /root/.ssh/*
fi

echo -e "\nUptime:"
echo -e "---------------\n"
/usr/bin/uptime

echo -e "\nStale files"
echo -e "---------------\n"
/bin/ls -l /proc/*/fd | /fabos/bin/grep -i delete

echo -e "\nTFTP info" 
echo -e "---------------\n"
/usr/bin/du -kh /tftpboot

echo -e "\nTFTP mace files" 
echo -e "------------------\n"
/bin/ls -l /tftpboot/mace | /usr/bin/wc -l

echo -e "\nRunning processes"
echo -e "-------------------\n"
/bin/ps exfcl

PROC_ENTRIES="meminfo slabinfo"
for i in $PROC_ENTRIES
do
	echo -e "\n /proc/$i"
	echo -e "-----------------\n"
	/bin/cat /proc/$i
done


for process in taped rekeyd cvlcd spcd
do
    proc_dir=/proc/`/sbin/pidof /fabos/libexec/$process`
    if [ -e $proc_dir ]; then
        echo -e "\n$process($proc_dir) info"
        echo -e "\nopen files:"
        $LS -l $proc_dir/fd
        echo -e "\nmemory maps:"
        $CAT $proc_dir/smaps
        echo -e "\nprocess stat:"
        $CAT $proc_dir/stat
        echo -e "\nprocess memory stat:"
        $CAT $proc_dir/statm
        echo -e "\nprocess memory status:"
        $CAT $proc_dir/status
    fi
done
