#!/bin/bash
# FFDC script to capture ipadm debugging data when bad things happen

# name of ipadmd process
ipadmd_name="ipadmd"

# pids <- list of pids of processes named ipadmd
pids=`ps --no-headers --format pid -C ${ipadmd_name}`

# get rid of the leading spaces
pidsnospaces=`echo "$pids" | tr -d \[\:blank\:\]`

echo ${ipadmd_name} pids ${pidsnospaces}

if [ -z "${pidsnospaces}" ]
then
	echo "${ipadmd_name}" is dead
	echo 'ls -al /tmp/ip*'
	/bin/ls -al /tmp/ip*
	if [ -r /tmp/ipadmd_log.txt ]
	then
		echo '/tmp/ipadmd_log.txt'
		cat /tmp/ipadmd_log.txt
	else
		echo '/tmp/ipadmd_log.txt is absent'
	fi

	if [ -r /etc/ipadmd_log.txt ]
	then
		echo '/etc/ipadmd_log.txt'
		cat /etc/ipadmd_log.txt
	else
		echo '/etc/ipadmd_log.txt is absent'
	fi

	exit 0
fi

# pid1 <- the first pid from the above list
pid1=`expr match "$pidsnospaces" '\([0-9]*\)'`

# send SIGUSR1 to ipadmd to generate its debug file
# also toggles ipadmd debug flag on
echo sending SIGUSR1 to ${pid1}
/bin/kill -s USR1 ${pid1}

# give OS a couple of seconds to deliver the signal
sleep 3

# toggle ipadmd debug flag back off
/bin/kill -s USR1 ${pid1}

# send the debug data to stdout so FFDC can capture it
echo 'ls -al /tmp/ip*'
/bin/ls -al /tmp/ip*
if [ -r /tmp/ipadm_data.txt ]
then
	echo '/tmp/ipadm_data.txt'
	cat /tmp/ipadm_data.txt
else
	echo '/tmp/ipadm_data.txt is absent'
fi

if [ -r /tmp/ipadmd_log.txt ]
then
	echo '/tmp/ipadmd_log.txt'
	cat /tmp/ipadmd_log.txt
else
	echo '/tmp/ipadmd_log.txt is absent'
fi

if [ -r /etc/ipadmd_log.txt ]
then
	echo '/etc/ipadmd_log.txt'
	cat /etc/ipadmd_log.txt
else
	echo '/etc/ipadmd_log.txt is absent'
fi

exit 0
