#ifndef _CSUTIL_H_
#define _CSUTIL_H_

#ifndef _KERNEL

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <time.h>
#include <ctype.h>
#include <memory.h>
#include <assert.h>
#include <dirent.h>

#include <sys/param.h>
#include <sys/uio.h>
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <sys/resource.h>
#include <netdb.h>
#include <pwd.h>

#define UDS_PATH_PREFIX "/var/uds/"

extern int	cs_utl_sock_inuse(int port);
extern void cs_utl_daemon(void);
extern char *cs_utl_basename(char *);
extern void cs_utl_setsig (int32_t sig, void (*fn)(int sig));
extern int  cs_utl_fd_set_block(int32_t fd);
extern int  cs_utl_fd_set_nonblock(int32_t fd);
extern int  cs_utl_listen(int ip, int port, struct sockaddr_in *rsaddr);
extern int 	cs_utl_uds_listen(char *path, struct sockaddr_un *rsaddr);
int cs_utl_iplist_get (char *name, unsigned int *iplist, int max, int *nret);
extern int  cs_utl_connect_nb(int ip, int port, struct sockaddr_in *lsaddr,
                                struct sockaddr_in *rsaddr, int *error);
extern int  cs_utl_uds_connect_nb(char *path, struct sockaddr_un *lsaddr, 
								struct sockaddr_un *rsaddr, int *error);
extern int  cs_utl_connect_nb_check(int fd, struct sockaddr_in *saddr,
                                                                int *error);

extern int  cs_utl_uds_connect_nb_check(int fd, struct sockaddr_un *saddr, 
																int *error);
extern int  cs_utl_connect(int ip, int port, int32_t timeout,
		  void *lsaddr, void *rsaddr, int *error);
extern int  cs_utl_writen(int fd, char *buf, int len, int timeout);
extern int  cs_utl_readn(int fd, char *buf, int len, int timeout);
extern int cs_utl_select(int nfd, fd_set *rfds, fd_set *wfds, fd_set *exfds,
        struct timeval *tv, int *err);
extern int  cs_utl_close(int fd, int *error);
extern int cs_utl_open(char *file, int flags, mode_t mode);
#define cs_utl_syslog           syslog
#define cs_utl_malloc           malloc
#define cs_utl_calloc           calloc
#define cs_utl_free             free
#define cs_utl_strstr           strstr
extern int  cs_utl_setsockopt(int fd, int level, int optname,
        const void *optval , socklen_t optlen, int *error);
extern int  cs_utl_read(int fd, void *buf, size_t nbytes, int *error);
extern int  cs_utl_write(int fd, void *buf, size_t nbytes, int *error);
extern int  cs_utl_writev(int fd, const struct iovec *iov, int iovcnt,
        int *error);
extern int  cs_utl_getsockname(int fd, struct sockaddr *name,
        socklen_t *namelen, int *error);
extern int  cs_utl_accept(int fd, struct sockaddr *addr, socklen_t *addrlen, int *error);
extern int cs_utl_socketpair(int dom, int type, int proto, int *sv, int *err);


#else /* _KERNEL */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/mbuf.h>
#include <netinet/in.h>
#include <sys/syslog.h>
#include <sys/socket.h>

#define cs_utl_daemon()
#define strerror(_errno)            #_errno
extern char *cs_utl_strstr(const char *big, const char *little);
extern int cs_utl_fd_set_block(int32_t fd);
extern int cs_utl_fd_set_nonblock(int32_t fd);
extern int cs_utl_listen(int ip, int port, struct sockaddr_in *rsaddr);
extern int cs_utl_connect_nb(int ip, int port, struct sockaddr_in *lsaddr,
        struct sockaddr_in *rsaddr, int *error);
extern int cs_utl_connect_nb_check(int fd, struct sockaddr_in *saddr,
        int *error);
extern int cs_utl_select(int nfd, fd_set *rfds, fd_set *wfds, fd_set *exfds,
        struct timeval *tv, int *err);
extern int cs_utl_close(int fd, int *error);
extern void cs_utl_syslog(int level, const char *fmt, ...);
extern int cs_utl_setsockopt(int fd, int level, int optname, const void *optval,
        socklen_t optlen, int *error);
extern int cs_utl_read(int fd, void *buf, size_t nbytes, int *error);
extern int cs_utl_write(int fd, void *buf, size_t nbytes, int *error);
extern int cs_utl_fpwrite(struct proc *proc, struct file *fp, void *buf, 
        size_t nbytes, int *error);
extern int cs_utl_writev(int fd, struct iovec *iov, int iovcnt,
        int *error);
extern int  cs_utl_getsockname(int fd, struct sockaddr *name,
        socklen_t *namelen, int *error);
extern int  cs_utl_accept(int fd, struct sockaddr *addr, socklen_t *addrlen, int *error);
extern void *cs_utl_calloc(size_t number, size_t size);
extern void *cs_utl_malloc(size_t size);
extern void cs_utl_free(void *p);
extern int cs_utl_iplist_get (char *name, unsigned int *iplist, int max, int *nret);
extern int cs_utl_socketpair(int dom, int type, int proto, int *sv, int *err);

#endif /* _KERNEL */

#endif /*_CS_UTIL_H_ */
