#ifndef _CS_POOL_H
#define _CS_POOL_H

#include "csq.h"

typedef struct {
    cs_q_t      qhead;          /* head of the pool                        */
    int         max;            /* max; provided during init               */
    int         growby;         /* pool grows by this number at a time     */
    int         bufsize;        /* buffer size                             */
    int         count;          /* total buffers in the pool               */
} cs_pool_t;

extern int   cs_pool_init    (int num, int max, int growby,
                              int bufsize, cs_pool_t **ph);
extern void *cs_pool_alloc   (cs_pool_t *ph);
extern void  cs_pool_free    (cs_pool_t *ph, void *pe);
extern void  cs_pool_destroy (cs_pool_t *ph);
extern bool_t cs_pool_is_empty (cs_pool_t *ph);

#endif /* _CS_POOL_H */
