#ifndef _CSFD_H_
#define _CSFD_H_

#include <sys/types.h>
#include <sys/time.h>

extern int      fd_high;
extern fd_set   fds_rd;
extern fd_set   fds_wr;

#define cs_fd_clear()         {FD_ZERO(&fds_rd); FD_ZERO(&fds_wr); fd_high=0;}

#define cs_fd_read_set(fd)    {fd_high=cs_max(fd, fd_high);FD_SET(fd, &fds_rd);}
#define cs_fd_read_clr(fd)     FD_CLR(fd, &fds_rd)
#define cs_fd_is_read_rdy(fd)  FD_ISSET(fd, &fds_rd)

#define cs_fd_write_set(fd)   {fd_high=cs_max(fd, fd_high);FD_SET(fd, &fds_wr);}
#define cs_fd_write_clr(fd)    FD_CLR(fd, &fds_wr)
#define cs_fd_is_write_rdy(fd) FD_ISSET(fd, &fds_wr)

extern int cs_fd_watch(struct timeval *tv, int *err);

#endif /* _CSFD_H_ */
