#ifndef __CSMSG_H__
#define __CSMSG_H__

#include <csmsg_queues.h>
#include <cmn_mhdr.h>

typedef cmn_mhdr_t   csmsg_hdr_t;

#define CSMSG_MAX_DEST_ADDR     RN_750_LOOPBACK


#define CSMSG_MAX_MSG_SIZE 		2232 
                                      
#define CSMSG_GET_PAYLOAD_PTR(_csmsg, _t) 							\
				(_t) (((char *) (_csmsg)) + sizeof(csmsg_hdr_t))

typedef enum {
	CS_OK 								= 0,
	CS_ERR 								= 1,
	CS_ERR_CSMSG_NO_ROUTE				= 2,
	CS_ERR_CSMSG_READ_FAILED 			= 3,
	CS_ERR_CSMSG_PAYLOAD_READ_FAILED 	= 4,
	CS_ERR_CSMSG_XBAR_WRITE_FAILED 		= 5,
} cserror_t;


#ifndef __KERNEL__

extern int csmsg_xbar_init(char *file_name);

extern cserror_t csmsg_read_xbar_msg(int xbar_fd, csmsg_hdr_t *csmsg);

extern cserror_t csmsg_alloc_read_xbar_msg(int xbar_fd, csmsg_hdr_t **csmsg);
																
extern cserror_t csmsg_send_xbar_msg(int xbar_fd, csmsg_hdr_t *csmsg); 
extern cserror_t csmsg_sendv_xbar_msg(int xbar_fd, struct iovec *iov, 
																	int iovcnt);
extern cserror_t csmsg_read_user_msg(int user_socket_fd, csmsg_hdr_t *csmsg);
extern cserror_t csmsg_alloc_read_user_msg(int user_socket_fd, 
														csmsg_hdr_t **csmsg);
extern cserror_t csmsg_fill_csmsg_hdr(int xbar_fd, csmsg_hdr_t *csmsg, 
										uint32_t msg_len, uint32_t dest_fc_dap);
#endif



#ifdef __KERNEL__
#define RN_ASSERT(_check) 													\
do {																		\
	if (!(_check)) {														\
		printk(KERN_CRIT "assert \"%s\" failed at File=%s, Line=%d\n", 			    \
                #_check, __FILE__, __LINE__);							    \
    }                                                                       \
} while(0);
#else
#define RN_ASSERT(_check)                                                   \
do {																		\
    if (!(_check)) {                                                        \
        uint32_t    *ptr = 0;                                               \
        printf( "assert \"%s\" failed at File=%s, Line=%d\n", 			    \
                #_check, __FILE__, __LINE__);							    \
		*ptr = 1;                                                  			\
    }                                                                       \
} while(0);

#endif

#endif /* __CSMSG_H__ */
