/*
 *
 *  Copyright (c) 2005 Brocade Communication Systems, Inc.
 *  All rights reserved.
 *
 *  Description:
 *		This file has the protocol header used by all transport across
 *		Blade and port management modules in both CP, BP and ARM processors.
 *
 *	NOTE:
 *		Changing this file will break protocols exchanged across multiple
 *		subsystems. DO NOT CHANGE THE FILE.
 *
 */

#ifndef __CMN_MHDR_H__
#define __CMN_MHDR_H__

#define MHDR_MAGIC 0x1A2B3C4D

typedef struct _cmn_mhdr_t {
	uint16_t size;		/* length of message including this header */
	uint8_t  sap;		/* Service Access Point */
	uint8_t  op;		/* operation code */ 
	uint8_t  src_slot;	/* source Id */ 
	uint8_t  dst_slot;	/* destination Id */
	uint8_t  flags;  	/* flags for special condition */	                                              
	uint8_t  result;	/* used to indicate result code for response messages */
	uint32_t trans_id;  /* application transaction ID	*/
	uint32_t magic_num; /* must be set to 0x1A2B3C4D	*/
	uint32_t sb_ws;		/* SB workspace					*/
} cmn_mhdr_t;

#endif	/*__CMN_MHDR_H__ */
