/*
 *
 *  Copyright (c) 2007 Brocade Communication Systems, Inc.
 *  All rights reserved.
 *
 *  Description:
 *      This file has data structures defined for transport message
 *		across scpd in CP and sbp in BP.
 *
 */
#ifndef __DMM_LIC_CMN_MHDR_H__
#define __DMM_LIC_CMN_MHDR_H__

#include <stdint.h>
#ifdef __cplusplus
extern "C" {
#endif

#define DMM_LIC_WWN_LENGTH 			24
#define DMM_LIC_MAX_LICENSES		3
#define DMM_LIC_MAX_WWN_COUNT		1024
#define DMM_LIC_KEY_LENGTH 			256
#define DMM_LIC_GUID_LENGTH			64

/* Bit positions */
#define DMM_LIC_BIT_BASIC		0x01
#define DMM_LIC_BIT_ENHANCED	0x02
#define DMM_LIC_BIT_WWN			0x04
#define DMM_LIC_BIT_TB_ONLINE	0x08
#define DMM_LIC_BIT_TB_OFFLINE	0x10

/* WWN structure */
typedef char wwn_id[8];

typedef struct {
	wwn_id	dmmwwn;
} dmm_lic_wwn_t;

/* DMM license key */
typedef struct {
	char dmmkey[DMM_LIC_KEY_LENGTH];
} dmm_lic_key_t;

/* DMM GUID */
typedef struct {
	char guid[DMM_LIC_GUID_LENGTH];
} dmm_lic_guid_t;

/* DMM license types */
typedef enum {

	DMM_LIC_WWN_ONLINE = 1,
	DMM_LIC_TB_ONLINE,
	DMM_LIC_TB_OFFLINE,
	DMM_LIC_ALL
	/* Any new valid license types should be added before this */
} dmm_lic_type_t;


/* message ids */
typedef enum {
	DMM_ADD_LIC = 1,   		/* Add DMM TB license */
	DMM_DEL_LIC,     		/* Delete DMM TB license */
	DMM_ADD_WWN,			/* Add DMM WWN license */
	DMM_QRY_LIC,	   		/* Query DMM license */
	DMM_GET_LIC,	   		/* Get all active DMM licenses */
	DMM_RESERVE_TBS,		/* Reserve available TB */
	DMM_RELEASE_TBS,		/* Release available TB */
	DMM_GET_WWN,			/* Get DMM WWN list */
	DMM_QRY_WWN,			/* Query WWN in WWN list */
	DMM_GET_INFO,			/* Query WWN in WWN list */
	DMM_PARSE_LIC,			/* Parse license key */
	DMM_COMMIT_TBS,			/* Confirms the use of the TB reserved */
	DMM_FLUSH_TBS,			/* Clear the Reserved data */
	DMM_INIT_LIC			/* Initialize the licensedb */
} dmm_lic_msg_id_t;


/* DMM license return status */
typedef enum {

	DMMLIC_SUCCESS = 0,
	DMMLIC_EFAILURE = -1,
	DMMLIC_EINVALID_LIC = -2,
	DMMLIC_ETB_LIC_PRESENT = -3,
	DMMLIC_EWWN_LIC_PRESENT = -4,
	DMMLIC_ELIC_NOT_PRESENT = -5,
	DMMLIC_ELIC_PRESENT = -6,
	DMMLIC_EWWN_PRESENT = -7,
	DMMLIC_EWWN_NOT_PRESENT = -8,
	DMMLIC_ELIMIT_REACHED = -9,
	DMMLIC_EALREADY_PRESENT = -10,
	DMMLIC_EINVALID_COUNT = -11,
	DMMLIC_EDB_EMPTY = -12,
	DMMLIC_EDB_NOT_FOUND = -13,
	DMMLIC_EDB_CORRUPTED = -14,
	DMMLIC_EDB_NOT_INITIALIZED = -15,
	DMMLIC_EDB_FULL = -16,
	DMMLIC_EDOWNGRADED_LIC = -17,
	DMMLIC_ELIC_CAN_BE_ADDED = -18,
	DMMLIC_EMEM_ALLOC = -19,
	DMMLIC_EUPDATE_FAILED = -20,
	DMMLIC_ESTR_CPY_ERR = -21,
	DMMLIC_EGET_LOCK_FAILURE = -22,
	DMMLIC_ERELEASE_LOCK_FAILURE = -23,
	DMMLIC_ETIMEOUT = -24,
	DMMLIC_EERR_BUSY = -25,
	DMMLIC_EINVALID_WWN = -26,
	DMMLIC_EINVALID_TYPE = -27,
	DMMLIC_ECB_NOT_REGISTERED = -28,
	DMMLIC_EINIT_ALREADY_DONE = -29,
	DMMLIC_ENOT_INITIALISED = -30,
	DMMLIC_ECPFAILURE = -31,
	DMMLIC_EINIT_FAILED = -32,
	DMMLIC_EBASIC_NOT_PRESENT = -33,
	DMMLIC_EENHANCED_NOT_PRESENT = -34,
	DMMLIC_EINVALID_DATA = -35
} dmm_lic_status_t;

/* DMM license information */
typedef struct dmm_lic_info{
	dmm_lic_key_t		key; 						/* license key */
	dmm_lic_type_t		type;						/* license type */
	uint64_t			limit;						/* maximum limit */
	uint64_t			consumed;					/* used count */
	uint8_t				version_major;				/* Version */
	uint8_t				version_minor;				/* Version */
} dmm_lic_info_t;


/* DMM license response structure */

/* Response structure to get all license */
typedef struct dmm_lic_get_wwn_list_resp {
	uint32_t			count;
	dmm_lic_info_t		dmm_lic[DMM_LIC_MAX_LICENSES];
} dmm_lic_get_all_lics_resp_t;

/* Response structure to get WWN list */
typedef struct dmm_lic_get_wwn_list {
	int					count;
	dmm_lic_wwn_t		wwn[DMM_LIC_MAX_WWN_COUNT];
} dmm_lic_get_wwn_list_resp_t;

/* Response structure to add WWN */
typedef struct dmm_lic_count {
	uint32_t			count;
} dmm_lic_count_t;

/* Response header structure */
typedef struct dmm_lic_resp_hdr {
	uint32_t			txid;			/* Transaction id */
	dmm_lic_msg_id_t	msgid;			/* Message id */
	dmm_lic_status_t	ret_status;		/* Status of the requested call */
} dmm_lic_resp_hdr_t;


/* DMM license request structure */

/* Request structure to add WWN or check if present */
typedef struct dmm_lic_wwn_req {
	dmm_lic_type_t		type;
	dmm_lic_wwn_t		wwn;			/* WWN */
} dmm_lic_wwn_req_t;

/* Request structure to allocate MBs */
typedef struct dmm_lic_tbs_req {
	dmm_lic_type_t		type;
	uint64_t			tbs;			/* mbs migrated */
} dmm_lic_tbs_req_t;

/* Request header structure */
typedef struct dmm_lic_req_hdr {
    uint32_t			txid;			/* Transaction id */
    dmm_lic_msg_id_t	msgid;			/* Message id */
} dmm_lic_req_hdr_t;

#ifdef __cplusplus
}
#endif

#endif /* __DMM_LIC_CMN_MHDR_H__ */
