#!/bin/sh
CORE_ROOT=/
CORE_FILES_DIR=core_files
MNT_DIR=mnt
CORE_TAR=*.tar
PATH=/bin:/usr/bin:
export ROLE_ID="root"

# Function to get a list of core files
getCoreFileList() {
	core_files_list=`/usr/bin/find ${CORE_ROOT}${CORE_FILES_DIR} ${CORE_ROOT}${MNT_DIR}/${CORE_FILES_DIR} \( -name "*ffdc*" -o -name "*core*" -o -name "*fx*" \) -type f -print 2> /dev/null`
	
	if [ -z "${core_files_list}" ]
	then
		printf "No core,ftrace or FFDC data files found!\n"
		exit
	fi
	tmpList=""
	for coreFile in ${core_files_list}
	do
		tmpList="${tmpList}  `/usr/bin/dirname ${coreFile}`"
	done
	core_files_list=`/bin/ls -d $tmpList | /bin/sort | /usr/bin/uniq`
	idx=0
	for coreFile in ${core_files_list}
	do
		coreFileArry[${idx}]="${coreFile}"
		coreSelArry[${idx}]=" "
		idx=`/usr/bin/expr ${idx} + 1`
	done
	coreFilesCount=$idx
}

# function to just list files on the terminal
tarAllFiles() {
	core_files_list=`/usr/bin/find ${CORE_ROOT}${CORE_FILES_DIR} ${CORE_ROOT}${MNT_DIR}/${CORE_FILES_DIR} \( -name "*ffdc*" -o -name "*core*" -o -name "*fx*" \) -type f -print 2> /dev/null`
	
	if [ -z "${core_files_list}" ]
	then
		printf "No core, ftrace or FFDC data files found!\n"
		exit 0 
	fi
	chmod 666 ${core_files_list}
	tmpList=""
	for coreFile in ${core_files_list}
	do
		tmpList="${tmpList}  `/usr/bin/dirname ${coreFile}`"
	done
	core_files_list=`/bin/ls -d $tmpList | /bin/sort | /usr/bin/uniq`
	idx=0

	if [  $argLog -eq 1 ]
	then
	    printf "tar file:${core_files_list}\n"
	fi

	tar -czPf ${cmdFileName} ${core_files_list}  2> /dev/null
}


# Function to remove ALL core files
rmCoreFilesListAll() {
	idx=0
	printf "Removing all core and FFDC files!\n"
	while [ $idx -lt $coreFilesCount ]
	do

        if [ "${coreFileArry[$idx]}" != "/core_files/sassvrd" ] &&
           [ "${coreFileArry[$idx]}" != "/mnt/core_files/sassvrd" ] &&
           [ "${coreFileArry[$idx]}" != "/core_files/dpc" ] &&
           [ "${coreFileArry[$idx]}" != "/core_files/sattoold" ] &&
           [ "${coreFileArry[$idx]}" != "/mnt/core_files/dpc" ] &&
           [ "${coreFileArry[$idx]}" != "/mnt/core_files/sattoold" ] &&
           [ "${coreFileArry[$idx]}" != "/mnt/core_files/supportshow" ] &&
           [ "${coreFileArry[$idx]}" != "/mnt/core_files/saslogupload" ]
        then
			/bin/rm -f ${coreFileArry[$idx]}/*
		fi
		# for fdet and ptlog in /core_files/
		name=${coreFileArry[$idx]:12:5}
		# for fdet and ptlog in /mnt/core_files/
		name1=${coreFileArry[$idx]:16:5}
		if [ "$name" = "fdet." -o "$name" = "ptlog" ] ||
		   [ "$name1" = "fdet." -o "$name1" = "ptlog" ]
		then
			/bin/rmdir ${coreFileArry[$idx]}
		fi
		idx=`/usr/bin/expr ${idx} + 1`
	done
	rm -f /core_files/*.tar
#	DP RAS second level cleanup
	/fabos/sbin/supportuffdc -p
}

# main starts here
	argRemoveAll=0	    	# Remove ALL core files	    (-R)
	argFtpAnon=""    	# FTP   user is anonimous   (-a)
	argRemoveTar=0	    	# FTP   user is anonimous   (-t)
	argLog=0                # FTP   user is anonimous   (-l)

# get the command options, if any
	while getopts Rla:t: c
	do
		case $c in
		R) argRemoveAll=1
		   ;;
		a) argFtpAnon=$OPTARG
		   ;;
		t) argRemoveTar= $OPTARG
		   ;;
		l) argLog=1
		   ;;
		*)
		   exit -1
		   ;;
		esac
	done

	# Remove all Files
	if [  $argRemoveAll -eq 1 ]
	then
		getCoreFileList
		rmCoreFilesListAll
		
		exit 0
	fi
	# create tar file 
	if [ -n "${argFtpAnon}" ]
	then
		cmdFileName="${argFtpAnon}"
	 	tarAllFiles
		exit 0
	fi

	# remove created tarfile 
	if [ -n "${argRemoveTar}" ]
	then
		cmdFileName="${argRemoveTar}"
		/bin/rm -f ${CORE_ROOT}${CORE_FILES_DIR}${CORE_ROOT}${cmdFileName}
		exit 0
	fi
