/*
 *
 *    Copyright (c) 2005 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Module name: swd_api.h
 *
 *    Description:
 *	  Marathon SWD API functions declarations
 */

#ifndef	__SWD_API_H__
#define	__SWD_API_H__

#ifdef __cplusplus
extern C {
#endif

#define SWD_APP_EMPTY	 0	/* must be zero */
#define SWD_APP_CRITICAL  1
#define SWD_APP_NORMAL    2



/*
 * SWD INTERFACE
 */
int	 swd_disable(void);
int	 swd_disable_app(void);
int	 swd_disable_switch(int);
int	 bswd_enable(void);
int	 swd_enable_app(void);
int	 swd_enable_switch(int);
int	 swd_get_timeout(u_long *);
int	 swd_init(char *);
void 	 swd_close(void);
int	 swd_list_all(char *, int);
int	 swd_read_conf(int swbd);
int	 swd_refresh(void);
int	 swd_set_min_timeout(int, int);
int	 swd_unregister(void);
int	 swd_get_fd();
int	 swd_register(char *, int, int *, char *,
						char *, int (*graceful_term_callback)(void));
int	 swd_register_dir(char *applName, int switchIns, int timeoutValue,
		 int retry, int type, char *cmd_path, char *args,
				  int (*graceful_term_callback)(void));
time_t 	 swd_refresh_to(void);
int	bswd_register(char *applName, int switchIns, int *timeoutValue,
    char *cmd_path, char *args, int (*graceful_term_callback)(void));
int	bswd_register(char *applName, int switchIns, int *timeoutValue,
    char *cmd_path, char *args, int (*graceful_term_callback)(void));
int bswd_init(char *applName);



#ifdef __cplusplus
}
#endif

#endif /* __SWD_API_H__ */
