/***********************************************************************
 *
 * Copyright 2002 (C)    Rhapsody Networks, Inc.
 *
 * Description:
 *		defines csmsg Q on the CM side
 *
 * Revision History:
 *      See the end of the file
 *
 * $Header: /cvs_mnt/devel/dev/src/switch/include/csmsg_queues.h,v 1.15 2003/01/28 18:31:31 avenkataraman Exp $
 *
 **********************************************************************/
#ifndef __CSMSG_QUEUES_H__
#define __CSMSG_QUEUES_H__

#define CSMSG_DEVFILE_PREFIX 	"/dev/csmsgdevs/"

/* */
#define CSMSG_MAX_QUEUES		64

#define CSMSG_MIN_USER_Q_NUM    0
#define CSMSG_MAX_USER_Q_NUM    55

#define CSMSG_MIN_KERN_Q_NUM    56
#define CSMSG_MAX_KERN_Q_NUM    63

#define IS_VALID_CSMSG_Q_NUM(_q) 	(((_q) < CSMSG_MAX_QUEUES) ? 1 : 0)

/* 
 * the following 2 macros assume that the queue number argument provided is in 
 * the range 0-63 
 */
#define IS_USER_Q(_q) 		(((_q) <= CSMSG_MAX_USER_Q_NUM) ? 1 : 0)
#define IS_KERN_Q(_q) 		(((_q) > CSMSG_MAX_USER_Q_NUM) ? 1 : 0)

/* 
 * Queue allocations are:
 *  0 - 31  - for user level Daemons
 *  32 - 63 - for Kernel modules
 */

/* 
 * Queues for User level Daemons 
 *
 * Queues 0 - 12 are reserved for HW in Figero. Usable queue number for 
 * user level is 13 - 55
 */

#define PORT_DBG_Q                  13  /* Printf msg from port to 750 */

#define CSMSG_ISCSI_MSG_Q           14
#define CSMSG_VTD_Q                 15
#define CSMSG_FABCTL_CONTROL_Q      16
#define CSMSG_FABCTL_FRAME_Q        17
#define CSMSG_DIR_SERVER_FRAME_Q    18
#define CSMSG_ZONE_SERVER_Q         19
/*#define CSMSG_VTD_Q                 20*/
#define CSMSG_FCPVTD_Q              21
#define CSMSG_FCVID_Q               22
#define CSMSG_VDBG_Q                23
#define CSMSG_FCIID_Q               24
#define CSMSG_FCITD_Q               25
#define CSMSG_IOMCTL_Q              26
#define CSMSG_FCIPD_Q               27  /* same as fg_Q_GM_FCIP_MsgQ */
#define CSMSG_IPFWD_Q               28  /* same as fg_Q_GM_IPFWD_MsgQ */
#define CSMSG_FCSAL_Q               29

#define CSMSG_DIAG_Q                30  /* Used for csmsg_diag frames */
#define CSMSG_PORTWALK_Q            31  /* == PORTWALK_Q (0x1F) in FiGeRo's */
#define CSMSG_VXSA_Q		        32  /* Used for vtvxd <--> vxio communication */
#define CSMSG_MGMT_SERVER_Q         33  /* Mgmt config server Q */
#define CSMSG_CONFIG_SERVER_Q       CSMSG_MGMT_SERVER_Q
#define CSMSG_RCS_Q                 34
#define CSMSG_ZS_CONTROL_Q          35
#define CSMSG_NSFC_Q                36  /* NSFCVI queue */
#define CSMSG_ISW_Q                 37
#define CSMSG_PORT_FAULT_Q          40  /* port_fault diagnostics queue */
#define CSMSG_IGD_Q                 41

/* 
 * Queues for Kernel Modules 
 * 
 * Usable queue numbers for kernel modules are 56-63. 
 * Pls add your new entries in reverse order. This is will enable moving 
 * of user/kernel queue number ranges smoothly (just in case it will be 
 * needed in future)
 */
#define CSMSG_PORTLOG_Q		        59  /* Used by portlog driver */
#define CSMSG_PSKD_Q		        60  /* Used by pskd to comm. with port  */
#define CSMSG_WKA_Q                 61
#define CSMSG_SIDFC_Q               62
#define CSMSG_VPIKD_Q               63

#endif /* __CSMSG_QUEUES_H__ */
