
/*
 *    Copyright (c) 1996-2005 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Module name: fabprop.h
 *
 *    Description:
 *    This file contains part of the generic Fabos Configuration definitions.
 */


#ifndef __SYS_FABPROP_H__
#define __SYS_FABPROP_H__

#ifdef __KERNEL__
#include <linux/types.h>
#elif defined __SOS__
#include "sos.h"
#include "types.h"
#elif defined __QNX__
#include <sys/types.h>
#else
#include <sys/types.h>
#endif /* __KERNEL__ */


typedef enum {
    TOPO_U_PORT = 0,
    TOPO_G_PORT = 1,
    TOPO_F_PORT = 2,
    TOPO_FL_PORT    = 3,
    TOPO_E_PORT = 4,
    TOPO_N_PORT = 5,
    TOPO_NL_PORT    = 6,
    TOPO_TOPO_LAST  = 7
} FCLinkTopo;

typedef struct _lnk_speed {
	u_int		auto_neg:1;	/*
							 * 1 = auto-neg at speed,
							 * 0 = do not use for auto-neg
							 */
	uint8_t		lnk_speed;	/* link speed in Gbps */
} lnk_speed_t;

#define LNK_SPEED_INITIALIZER(arg_an, arg_gbps) \
	{ \
		.auto_neg = arg_an, \
		.lnk_speed = arg_gbps }

typedef struct _linkcap {
	u_int		has_serdes:1;		/* external serdes present? */
	u_int		has_media:1;		/* port media slot present? */
	FCLinkTopo	topology:3;			/* any pre-wired topology */
	u_int		skip_nego:1;		/* skip frame-level negotiation
									   during link init */
	u_int		skip_pnego:1;		/* skip primtive-level nego.
									   during link init */
	u_int		skip_init_event:1;	/* skip sw init event during link init */
	u_int		en_shim:1;			/* enable shim in frame header? */
	u_int 		speed_neg:1;		/* perform auto speed negotiation */
	u_int		master_role:1;		/* bringup the port as Master */
	u_int		loop_back:1;		/* setup port as loopback */
	u_int		listc_trap:1;		/* setup LISTC_TRAP for this port */
	u_int		no_discard_to:1;	/* skip discard timeout */
	u_int		dis_cport_mode:1;	/* Disable cport mode to allow DID lookup */
	u_int		int_flex_topo:1;	/* internal port with flexible topology */
	u_int		enable_vsan:1;		/* enable VSAN on this port */
	uint8_t		num_speeds;			/* number of speeds used for
									   speed negotiation */
	lnk_speed_t	*speed_list;		/* list of speeds value for
									   speed negotiation */
	u_int		to_cred_loss_detection:1; /* TO trigger cred loss detection */

} link_cap_t; 

#define LINK_CAP_INITIALIZER( \
			arg_has_srd, arg_has_med, arg_topo, arg_sneg, arg_spneg, \
			arg_skip_ini, arg_en_shim, arg_sn, arg_master, arg_lb, arg_listc, \
			arg_nodisc_to, arg_dis_cport, arg_flex_topo, arg_enable_vsan, arg_num_sp, arg_slist) \
			{ \
				.has_serdes			= arg_has_srd,	\
				.has_media			= arg_has_med,	\
				.topology			= arg_topo,		\
				.skip_nego			= arg_sneg,		\
				.skip_pnego			= arg_spneg,	\
				.skip_init_event	= arg_skip_ini,	\
				.en_shim			= arg_en_shim,	\
				.speed_neg			= arg_sn,		\
				.master_role			= arg_master,		\
				.loop_back			= arg_lb,		\
				.listc_trap			= arg_listc,		\
				.no_discard_to		= arg_nodisc_to, 	\
				.dis_cport_mode		= arg_dis_cport, 	\
				.int_flex_topo		= arg_flex_topo,	\
				.enable_vsan		= arg_enable_vsan,	\
				.num_speeds			= arg_num_sp,	\
				.speed_list			= arg_slist }

typedef struct _credit_model {
	uint16_t	num_vcs; /* number of VCs supported */
	uint16_t 	min_bufs; /* min buffers that has to be allocated to port */
	uint16_t	qos_num_vcs;
	uint16_t	qos_bufs;
	/*
	 * Following field is used dependent on the port type (FE vs BE)
	 * FE : define the minimum buffers per VC
	 * BE : define the num_vcs and vc_alloc for self 
	 * in the blade definition and later during attach
	 * gets replaced by their respective peer port values before 
	 * being pushed down to the ASIC driver
	 */
	uint16_t	*vc_alloc; /* min buffers per VC */
	uint16_t	*norm_vc_alloc; /* normal buffers per VC : ONLY for FE */
	uint16_t	*qos_vc_alloc;
	uint16_t	*qos_cr_shar;
	uint16_t	*cr_shared;
	uint16_t	cr_shar_bufs; /* number of buffers that can be shared */
	uint16_t	qos_cr_shar_bufs;
	uint16_t	cr_share_for_vc0;	/* shared buffers for vc0 */
	uint16_t	cr_share_for_vcx;	/* shared buffers for non-0 vc */
	uint16_t	jumbo_frm_size;		/* size of jumbo frame */
	uint16_t	jumbo_frame:1;		/* Jumbo frame supported */
	uint16_t	skip_bb_credit:1;	/* skip BB credit */
	uint16_t	use_shim_based_sublist:1;	/* use shim based sublist */
} cr_model_t;

typedef struct _credit_model_old {
	uint16_t	num_vcs; /* number of VCs supported */
	uint16_t 	min_bufs; /* min buffers that has to be allocated to port */
	uint16_t	qos_num_vcs;
	uint16_t	qos_bufs;
	/*
	 * Following field is used dependent on the port type (FE vs BE)
	 * FE : define the minimum buffers per VC
	 * BE : define the num_vcs and vc_alloc for self 
	 * in the blade definition and later during attach
	 * gets replaced by their respective peer port values before 
	 * being pushed down to the ASIC driver
	 */
	uint16_t	*vc_alloc; /* min buffers per VC */
	uint16_t	*norm_vc_alloc; /* normal buffers per VC : ONLY for FE */
	uint16_t	*qos_vc_alloc;
	uint16_t	*qos_cr_shar;
	uint16_t	*cr_shared;
	uint16_t	cr_shar_bufs; /* number of buffers that can be shared */
	uint16_t	qos_cr_shar_bufs;
	uint16_t	cr_share_for_vc0;	/* shared buffers for vc0 */
	uint16_t	cr_share_for_vcx;	/* shared buffers for non-0 vc */
} cr_model_old_t;

#define CREDIT_MODEL_INITIALIZER( \
			arg_num_vcs, arg_min_bufs, arg_vc, arg_norm_vc, arg_bufs, \
			arg_cr_share_vc0, arg_cr_share_vcx, arg_cr_shar, \
			arg_qos_num_vcs, arg_qos_bufs, arg_qos_vc_alloc, \
			arg_qos_cr_shar, arg_qos_cr_shar_bufs, arg_jumbo_frm_sz, \
			arg_jumbo_frame, arg_skip_bb_credit, arg_shim_sublist) \
			{ \
				.num_vcs			= arg_num_vcs,		\
				.min_bufs			= arg_min_bufs,		\
				.vc_alloc			= arg_vc,			\
				.norm_vc_alloc		= arg_norm_vc,		\
				.cr_shar_bufs		= arg_bufs,			\
				.cr_share_for_vc0	= arg_cr_share_vc0,	\
				.cr_share_for_vcx	= arg_cr_share_vcx,	\
				.cr_shared			= arg_cr_shar,		\
				.qos_num_vcs		= arg_qos_num_vcs,	\
				.qos_bufs			= arg_qos_bufs,		\
				.qos_vc_alloc		= arg_qos_vc_alloc,	\
				.qos_cr_shar		= arg_qos_cr_shar,	\
				.qos_cr_shar_bufs	= arg_qos_cr_shar_bufs, \
				.jumbo_frm_size		= arg_jumbo_frm_sz,	\
				.jumbo_frame		= arg_jumbo_frame,	\
				.skip_bb_credit		= arg_skip_bb_credit,	\
				.use_shim_based_sublist = arg_shim_sublist}


#endif  /* __SYS_FABPROP_H__ */

