/*
 *
 *    Copyright (c) 2006-2007 Brocade Communication Systems, Inc.
 *    All rights reserved.
 *
 *    Module name: ki.h
 *
 *    Description:
 *      KI user space header - exports API available from the ki library
 */

#ifndef KI_KI_H
#define KI_KI_H

#include <giot/ioss.h>	/* ioss */
#include <sys/ki/shared.h>	/* ki_args_t */

#ifdef __cplusplus
extern C {
#endif

int ki_constructor(unsigned int instance);
int ki_destructor(unsigned int instance);
int ki_state_set(int activate, unsigned int instance);
int ki_open(void **mmap_ptr);	/* assume this done to instantiate base ki */
void ki_close();	/* assume this done for the current ki instance */

/* synch interaction */
int ki_execute(const ki_args_t *ioc, unsigned int instance);

/* process async received messages */
typedef struct ki_private ki_private_t;
int ki_retrieve(ki_private_t *kip, void *buf, size_t size);
int ki_fix_args(ki_args_t *buf, size_t size);
int ki_fix_argv(struct iovec *iov, size_t count, char *data_area);

typedef void (*ki_process_t)(ki_private_t *kip, size_t size, void *ctx);
int ki_register(int dev_id, ki_process_t proc, void *ctx);


/* special stuff */
int ki_scn_register(int k0, u_int the_data[][2], uint count,
		unsigned int instance);
int ki_scn_unregister(int k0, u_int the_data[][2], uint count,
		unsigned int instance);

#ifdef __cplusplus
}
#endif

#endif	/* KI_KI_H */
