/*
 *    Copyright (c) 1996-2006 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *      Header for SWD API modules.
 *
 */
#ifndef __HASM_SWD_H__ /* { */
#define __HASM_SWD_H__

#ifdef __cplusplus
extern C {
#endif

#include <time.h>
#include <sys/types.h>
#include <ctype.h>
#include <sys/timeb.h>
#include <time.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/hasm/swd.h>

extern	int	swd_init(void);
extern	void	swd_exit(void);
extern	int	swd_disable(void);
extern	int	swd_enable(void);
extern	int	swd_suppress(void);
extern	int	swd_populate(char *sname, int num, swd_cfg_t conf[]);
extern	void	swd_failover(void);
extern	int	swd_register(char *comp);
extern	int	swd_hello(int swd, time_t *past);
extern	int	swd_unregister(int swd);
extern  int swd_get_hndl(void);
/*
 * these api are deprecated
 */
static	inline int
swd_refresh_to(void)
{
	return (SWD_REFRESH_TO*1000);
}

static	inline void
swd_refresh(void)
{
}

#ifdef __cplusplus
}
#endif

#endif /* __HASM_SWD_H__ } */
