#ifndef _CSTMR_H
#define _CSTMR_H

#include <linux/param.h>
#include <linux/sysctl.h>
/*#include <machine/cpu.h>*/
#include "cs/cscn.h"

#define CS_TMR_TZNULL            (struct timezone *)0
#define CS_TMR_INFINITE          -1

#define m_cs_tmr_secs(msecs)     (msecs / 1000L)
#define m_cs_tmr_usecs(msecs)    (msecs % 1000L)*1000L
#define m_cs_tmr_msecdiff(n, o)  (n->tv_sec  - o->tv_sec) * 1000L + \
                                 (n->tv_usec - o->tv_usec) / 1000L
#define m_cs_tmr_msecdiffs(n, o) (n.tv_sec  - o.tv_sec) * 1000L + \
                                 (n.tv_usec - o.tv_usec) / 1000L
#define m_cs_tmr_checkusec(t)    if (t->tv.tv_usec >= 1000000L) { \
                                 t->tv.tv_sec += t->tv.tv_usec / 1000000L; \
                                 t->tv.tv_usec %= 1000000L; }

extern cs_q_t tmr_usedq;
extern cs_q_t tmr_freeq;

/* timer prototype */
int             cs_monotime(struct timeval *);
struct timeval *cs_tmr_timeout (struct timeval *tvnow);
void            cs_tmr_run (struct timeval *tvnow);
void            cs_tmr_reset (struct timeval *tvnow, cn_tmr_hdl_t *tp);
void            cs_tmr_cleanup (void);
void            cs_tmr_destroy (void);


#define NS_PER_SEC         (1000000000)
#define MERC_CPU_TIMEBASE  (50000000 / 4)   /* ticks_per_sec */


#if !defined(_KERNEL) && !defined(KERNEL)

extern uint32_t ns_per_tick;

#if 0
static inline uint32_t
get_ns_per_tick()
{
    if (ns_per_tick)
        return ns_per_tick;
    else {
        int mib[2];
        uint32_t cpu_timebase, tb_len;
        mib[0] = CTL_MACHDEP;
        mib[1] = CPU_TIMEBASE;
        tb_len = sizeof(cpu_timebase);
        if (sysctl(mib, 2, &cpu_timebase, &tb_len, NULL, 0) == -1) {
            if (EOPNOTSUPP == errno)
                ns_per_tick = NS_PER_SEC / MERC_CPU_TIMEBASE; /* Default value */
            else
                cs_assert(0);
        }
        else 
            ns_per_tick = NS_PER_SEC / cpu_timebase;
        return ns_per_tick;
    }
}
#endif
/**************************************************************/
/* Our linux kernel doesn't support this specific sysctl info */
/* Use hardcode value now.									  */
/**************************************************************/
#ifdef FORTE			/* should define either FORTE or CM */
#define CPU_FREQ_MICRO		466
#else
#define CPU_FREQ_MICRO		466		/* This is suppose to be CM */
#endif

static inline uint32_t
get_ns_per_tick()
{
	return 1000 / CPU_FREQ_MICRO ;
}

#else /* KERNEL */
extern int cpu_timebase;
#define NS_PER_TICK  (NS_PER_SEC / cpu_timebase)
#endif

#if 0 
static inline uint64_t 
mftb(void) 
{ 
    u_long scratch; 
    u_quad_t tb; 
         
    asm ("1: mftbu %0; mftb %0+1; mftbu %1; cmpw %0,%1; bne 1b" 
         : "=r"(tb), "=r"(scratch)); 
    return tb; 
}
#endif

/*
 * Following is basically a copy form ../include/asm-ppc/time.h.
 * The routine is suppose to return 64-bit TB register value
 */
extern __inline__ unsigned long get_tbl(void) {
	unsigned long tbl;
#if defined(CONFIG_403GCX)
	asm volatile("mfspr %0, 0x3dd" : "=r" (tbl));
#else
	asm volatile("mftb %0" : "=r" (tbl));
#endif
	return tbl;
}

extern __inline__ unsigned long get_tbu(void) {
	unsigned long tbl;
#if defined(CONFIG_403GCX)
	asm volatile("mfspr %0, 0x3dc" : "=r" (tbl));
#else
	asm volatile("mftbu %0" : "=r" (tbl));
#endif
	return tbl;
}


static inline uint64_t 
mftb(void)
{
   uint64_t tb;

   tb = get_tbu();
   tb = (tb << 32) + get_tbl();

   return tb;

}

#endif /* _CSTMR_H */
