/*
 *    Copyright (c) 2003-2004 by Brocade Communications Systems, Inc.
 *    All rights reserved.
 *
 *    Description:
 *      RASLOG Header File
 *
 */
#ifndef	__RASLOG_H__
#define	__RASLOG_H__

#include <ras/ras_modules.h>		/* RAS_LOG_ID */
#include <ras/tpa_ras_modules.h>	/* TPA RAS_LOG_ID */

#ifdef	__KERNEL__
#include <linux/types.h>
#else
#include <sys/types.h>
#endif

#include <ras/ras_event.h>

/*
 ********************************************************************
 * This section was define in other fabos incldue files. Need come back
 * to export orginal file to exported area
 ********************************************************************
 */
typedef ras_hndl_t raslog_hndl_t;
typedef rasevt_severity_t raslog_severity_t;

#define RASLOG_NOFLAGS  	RASEVT_NOFLAGS
#define RASLOG_FRCLOG		RASEVT_FRCLOG 
#define RASLOG_NO_SEEPROM	RASEVT_NO_SEEPROM
#define RASLOG_FORCE_SEEPROM	RASEVT_FORCE_SEEPROM
#define RASLOG_NOTRAP		RASEVT_NOTRAP
#define RASLOG_NODIAG		RASEVT_NODIAG
#define RASLOG_NOBURNIN		RASEVT_NOFLAGS  

#define RASLOG_CRITICAL		RASEVT_CRITICAL
#define RASLOG_ERROR		RASEVT_ERROR
#define RASLOG_WARNING		RASEVT_WARNING
#define RASLOG_INFO		RASEVT_INFO
#define RASLOG_SEVERITY_MAX	RASEVT_SEVERITY_MAX

#define RASLOG_OID_INVALID   	RASEVT_OID_INVALID

// #include <switch/switch.h>	/* for OK/ERROR return codes */
#define RASLOG_OK		RASEVT_OK


/*
 * RASLOG return codes
 */
#define RASLOG_SUCCESS      (0)
#define RASLOG_ERR_GENERIC  (-1)
#define RASLOG_ERR RASLOG_ERR_GENERIC
#define RASLOG_ERR_BADSTATE (-2)
#define RASLOG_ERR_NOTINIT  (-3)
#define RASLOG_ERR_BADINPUT (-4)
#define RASLOG_ERR_NOMEM    (-5)
#define RASLOG_ERR_NORESOURCES  (-6)
#define RASLOG_ERR_CORRUPT  (-7)
#define RASLOG_ERR_LISTEMPTY    (-8)

#ifdef __KERNEL__

#define raslog_gethndl 	rasevt_gethndl
#define raslog		rasevt

#else /* __USER__ */

#define raslog_init 	rasevt_init
#define raslog_exit 	rasevt_exit
#define	raslog_init_check rasevt_init_check
#define raslog		rasevt


#endif /* __KERNEL__ */




#endif /* __RASLOG_H__ */
